/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.IncrementalBuildExecutionDigest;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.lib.YarnExecutor;
import com.github.eirslett.maven.plugins.frontend.lib.YarnExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.YarnRunner;
import com.github.eirslett.maven.plugins.frontend.lib.YarnTaskExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

final class DefaultYarnRunner
extends YarnTaskExecutor
implements YarnRunner {
    private static final String TASK_NAME = "yarn";

    public DefaultYarnRunner(YarnExecutorConfig config, ProxyConfig proxyConfig, String npmRegistryURL) {
        super(config, TASK_NAME, config.getYarnPath().getAbsolutePath(), DefaultYarnRunner.buildArguments(config, proxyConfig, npmRegistryURL));
    }

    private static List<String> buildArguments(YarnExecutorConfig config, ProxyConfig proxyConfig, String npmRegistryURL) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (config.isYarnBerry()) {
            return arguments;
        }
        if (npmRegistryURL != null && !npmRegistryURL.isEmpty()) {
            arguments.add("--registry=" + npmRegistryURL);
        }
        if (!proxyConfig.isEmpty()) {
            ProxyConfig.Proxy proxy = null;
            if (npmRegistryURL != null && !npmRegistryURL.isEmpty()) {
                proxy = proxyConfig.getProxyForUrl(npmRegistryURL);
            }
            if (proxy == null) {
                proxy = proxyConfig.getSecureProxy();
            }
            if (proxy == null) {
                proxy = proxyConfig.getInsecureProxy();
            }
            arguments.add("--https-proxy=" + proxy.getUri().toString());
            arguments.add("--proxy=" + proxy.getUri().toString());
        }
        return arguments;
    }

    @Override
    public Optional<IncrementalBuildExecutionDigest.Execution.Runtime> getRuntime() {
        try {
            String output = new YarnExecutor(this.config, Arrays.asList("node", "--version"), Collections.emptyMap()).executeAndGetResult(this.logger);
            if (output.startsWith("yarn node")) {
                output = output.substring(output.indexOf("\n"), output.lastIndexOf("\n")).trim();
            }
            return Optional.of(new IncrementalBuildExecutionDigest.Execution.Runtime("node", output));
        }
        catch (Exception exception) {
            this.logger.debug("Failed to get the Node version from yarn, will fallback and hope it's yarn classic. Failed because: ", (Throwable)exception);
            try {
                String rawVersions = new YarnExecutor(this.config, Collections.singletonList("versions"), Collections.emptyMap()).executeAndGetResult(this.logger);
                int startIndex = rawVersions.indexOf("{");
                int endIndex = rawVersions.indexOf("}") + 1;
                String desiredVersions = rawVersions.substring(startIndex, endIndex).replaceAll("\\s+", "");
                return Optional.of(new IncrementalBuildExecutionDigest.Execution.Runtime(TASK_NAME, desiredVersions));
            }
            catch (Exception exception2) {
                this.logger.debug("Failed to get the Node version from yarn, even after assuming it's yarn classic. Failed because: ", (Throwable)exception2);
                return Optional.empty();
            }
        }
    }
}

