/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.test_data.operationaltemplate;

import java.io.InputStream;
import java.util.Arrays;

public enum OperationalTemplateTestData {
    IDCR_IMMUNISATION_SUMMARY("IDCR Immunisation summary", "IDCR - Immunisation summary.v0.opt", "IDCR - Immunisation summary.v0"),
    RIPPLE_CONFORMANCE_TEST("RIPPLE Conformance Test", "RIPPLE-Conformance Test.opt", "RIPPLE - Conformance Test template"),
    IDCR_LABORATORY_TEST("IDCR  Laboratory Test Report", "IDCR - Laboratory Test Report.v0.opt", "IDCR - Laboratory Test Report.v0"),
    EHRN_VITAL_SIGNS_TEST("EHRN Vital signs.v2", "EHRN Vital signs.v2.opt", "EHRN Vital signs.v2"),
    IDCR_PROBLEM_LIST("IDCR  Problem List.v1", "IDCR - Problem List.v1.opt", "IDCR - Problem List.v1"),
    IDCR_ADVERSE_REACTION_LIST("IDCR -  Adverse Reaction List.v1", "IDCR - Adverse Reaction List.v1.opt", "Adverse Reaction List.v1"),
    BLOOD_PRESSURE_SIMPLE("Very simple blood_pressure template", "ehrbase_blood_pressure_simple.de.v0.opt", "ehrbase_blood_pressure_simple.de.v0"),
    MULTI_OCCURRENCE("Template with multiple occurrence", "ehrbase_multi_occurrence.de.opt", "ehrbase_multi_occurrence.de.v1"),
    ALL_TYPES("Template with all types", "Test_all_types.opt", "test_all_types.en.v1"),
    ALT_EVENTS("Template with alternative Events", "AlternativeEvents.opt", "AlternativeEvents"),
    TWO_EVENTS("Template with two Events", "TwoEvents.opt", "SingleEvent"),
    AVERAGE_24("Template with  a Interval Events", "24StundenDurchschnitt.opt", "24StundenDurchschnitt"),
    EPISODE_OF_CARE("EpisodeOfCare", "EpisodeOfCare.opt", "EpisodeOfCare"),
    CORONA_ANAMNESE("Corona_Anamnese", "corona_anamnese.opt", "Corona_Anamnese"),
    DIAGNOSE("Diagnose", "Diagnose.opt", "Diagnose"),
    OPEN_E_REACT_CARE("open_eREACT-Care", "open_eREACT-Care.opt", "open_eREACT-Care"),
    SCHWANGERSCHAFTSSTATUS("Schwangerschaftsstatus", "Schwangerschaftsstatus.opt", "Schwangerschaftsstatus"),
    VIROLOGY_FINDING("Virologischer Befund", "Virologischer_Befund.opt", "Virologischer Befund"),
    BEFUND_DER_BLUTGASANALYSE("Befund der Blutgasanalyse", "Befund_der_Blutgasanalyse.opt", "Befund der Blutgasanalyse"),
    SM_I_C_S_BEFUND("SmICS-Befund", "SmICS-Befund.opt", "SmICS-Befund"),
    PATIENTEN_AUFENTHALT("NUM test hospitalization", "Patientenaufenthalt.opt", "Patientenaufenthalt"),
    EPISODE_SUMMARY("Station\u00e4rer Versorgungsfall", "station\u00e4rer_versorgungsfall.opt", "Station\u00e4rer Versorgungsfall"),
    INITIAL_ASSESSMENT("example.initialassesment.v0", "example_initialassesment.v0.opt", "example.initialassesment.v0"),
    D4L_QUESTIONNAIRE("D4L_questionnaire", "D4L_questionnaire.opt", "D4L_questionnaire"),
    CONSTRAIN_TEST("example with many constrains / default values", "constrain_test.opt", "constrain_test"),
    LANGUAGE_TEST("example with multiple languages", "language_test.opt", "language_test"),
    SINGLE_EVENT("example with a single valued EVENT", "single_event.opt", "K\u00f6rpergr\u00f6\u00dfe"),
    ADDICTION("example ", "additciton_alcohol.opt", "AddictionAlcoholTemplate"),
    MINIMAL_EVALUATION("minimal evaluation", "minimal_evaluation.opt", "minimal_evaluation.en.v1"),
    GECCO_SEROLOGISCHER_BEFUND("template with any Element", "GECCO_Serologischer Befund.opt", "GECCO_Serologischer Befund"),
    DETERIORIATION_ASSESSMENT("Deterioriation assessment ", "EREACT - Deterioriation assessment.v0.opt", "EREACT - Deterioriation assessment.v0"),
    VIROLOGISCHER_BEFUND("Virologischer Befund", "Virologischer_Befund.opt", "Virologischer Befund"),
    LABOR_BEFUND("Labor Befund", "laborbefund.opt", "Laborbefund");

    private final String filename;
    private final String templateId;
    private final String description;

    private OperationalTemplateTestData(String description, String filename, String templateId) {
        this.filename = filename;
        this.description = description;
        this.templateId = templateId;
    }

    public InputStream getStream() {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/operationaltemplate/" + this.filename);
    }

    public static OperationalTemplateTestData findByTemplateId(String templateId) {
        return Arrays.stream(OperationalTemplateTestData.values()).filter(o -> o.getTemplateId().equals(templateId)).findAny().orElse(null);
    }

    public String getTemplateId() {
        return this.templateId;
    }
}

