/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.terminology.openehr.implementation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ehrbase.terminology.openehr.CodeSetAccess;
import org.ehrbase.terminology.openehr.OpenEHRCodeSetIdentifiers;
import org.ehrbase.terminology.openehr.TerminologyAccess;
import org.ehrbase.terminology.openehr.TerminologyInterface;
import org.ehrbase.terminology.openehr.TerminologyResourceException;
import org.ehrbase.terminology.openehr.implementation.Code;
import org.ehrbase.terminology.openehr.implementation.CodeSet;
import org.ehrbase.terminology.openehr.implementation.Concept;
import org.ehrbase.terminology.openehr.implementation.Group;
import org.ehrbase.terminology.openehr.implementation.SimpleCodeSetAccess;
import org.ehrbase.terminology.openehr.implementation.SimpleTerminologyAccess;
import org.ehrbase.terminology.openehr.implementation.TerminologySource;
import org.ehrbase.terminology.openehr.implementation.TerminologySourceFactory;

public class SimpleTerminologyInterface
implements TerminologyInterface {
    private Map<String, CodeSetAccess> codeSets;
    private Map<String, TerminologyAccess> terminologies = new HashMap<String, TerminologyAccess>();
    private Map<String, String> codeSetInternalIdToExternalName;

    @Override
    public TerminologyAccess terminology(String name) {
        return this.terminologies.get(name);
    }

    @Override
    public CodeSetAccess codeSet(String name) {
        return this.codeSets.get(name);
    }

    @Override
    public CodeSetAccess codeSetForId(OpenEHRCodeSetIdentifiers id) {
        String name = this.codeSetInternalIdToExternalName.get(id.toString());
        if (name == null) {
            return null;
        }
        return this.codeSets.get(name);
    }

    @Override
    public boolean hasTerminology(String name) {
        return this.terminologies.containsKey(name);
    }

    @Override
    public boolean hasCodeSet(String name) {
        return this.codeSetInternalIdToExternalName.containsKey(name);
    }

    @Override
    public List<String> terminologyIdentifiers() {
        return new ArrayList<String>(this.terminologies.keySet());
    }

    @Override
    public List<String> codeSetIdentifiers() {
        return new ArrayList<String>(this.codeSets.keySet());
    }

    @Override
    public Map<String, String> openehrCodeSets() {
        return Collections.unmodifiableMap(this.codeSetInternalIdToExternalName);
    }

    SimpleTerminologyInterface(String language) {
        this.codeSets = new HashMap<String, CodeSetAccess>();
        this.codeSetInternalIdToExternalName = new HashMap<String, String>();
        try {
            TerminologySource terminologySource = TerminologySourceFactory.getOpenEHRTerminology(language);
            this.loadTerminologies(terminologySource, language);
            this.loadCodeSets(terminologySource);
            terminologySource = TerminologySourceFactory.getExternalTerminologies(language);
            this.loadTerminologies(terminologySource, language);
            this.loadCodeSets(terminologySource);
        }
        catch (Exception e) {
            throw new TerminologyResourceException(e.getMessage());
        }
    }

    private void loadTerminologies(TerminologySource source, String language) {
        SimpleTerminologyAccess terminology = (SimpleTerminologyAccess)this.terminologies.get("openehr");
        if (terminology == null) {
            terminology = new SimpleTerminologyAccess("openehr");
        }
        List<Group> groups = source.getConceptGroups();
        for (Group group : groups) {
            HashSet<String> codes = new HashSet<String>();
            HashMap<String, String> names = new HashMap<String, String>();
            names.put(language, group.name);
            for (Concept concept : group.concepts) {
                codes.add(concept.id);
                terminology.addRubric(language, concept.id, concept.rubric);
            }
            terminology.addGroup(group.name, codes, names);
        }
        this.terminologies.put("openehr", terminology);
    }

    private void loadCodeSets(TerminologySource source) {
        for (CodeSet codeset : source.getCodeSets()) {
            SimpleCodeSetAccess codeSetAccess = new SimpleCodeSetAccess(codeset.externalId, new HashSet<Code>(codeset.codes));
            this.codeSets.put(codeset.externalId, codeSetAccess);
            this.codeSetInternalIdToExternalName.put(codeset.openehrId, codeset.externalId);
        }
    }
}

