/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.terminology.openehr.implementation;

import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.terminology.openehr.CodeSetAccess;
import org.ehrbase.terminology.openehr.implementation.Code;

public class SimpleCodeSetAccess
implements CodeSetAccess {
    private final String id;
    private final Set<CodePhrase> allCodes;

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Set<CodePhrase> allCodes() {
        return this.allCodes;
    }

    @Override
    public boolean hasCode(CodePhrase code) {
        if (code == null) {
            throw new IllegalArgumentException("code null");
        }
        return this.allCodes.contains(code);
    }

    @Override
    public boolean hasLang(CodePhrase lang) {
        return false;
    }

    SimpleCodeSetAccess(String id, Set<Code> codes) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("null or empty id");
        }
        if (codes == null || codes.isEmpty()) {
            throw new IllegalArgumentException("null or empty codes");
        }
        this.id = id;
        this.allCodes = new HashSet<CodePhrase>();
        for (Code code : codes) {
            CodePhrase cp = new CodePhrase(new TerminologyId(id), code.getCode());
            this.allCodes.add(cp);
        }
    }
}

