/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.terminology.client.terminology;

import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.terminology.client.terminology.TermDefinition;
import org.ehrbase.terminology.client.terminology.ValueSet;
import org.ehrbase.terminology.openehr.implementation.LocalizedTerminologies;
import org.ehrbase.util.exception.SdkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminologyProvider {
    public static final String OPENEHR = "openehr";
    private static final LocalizedTerminologies LOCALIZED_TERMINOLOGIES;
    private static final Logger LOGGER;

    public static ValueSet findOpenEhrValueSet(String id, String group, String language) {
        try {
            if (StringUtils.isNotBlank((CharSequence)group)) {
                return new ValueSet(id, group, LOCALIZED_TERMINOLOGIES.getDefault().terminology(id).codesForGroupId(group).stream().map(cp -> TerminologyProvider.convert(id, cp, language)).collect(Collectors.toSet()));
            }
            return new ValueSet(id, "all", LOCALIZED_TERMINOLOGIES.getDefault().codeSet(id).allCodes().stream().map(cp -> TerminologyProvider.convert(id, cp, language)).collect(Collectors.toSet()));
        }
        catch (RuntimeException e) {
            LOGGER.warn("Unknown  group {} in Terminology {}", (Object)group, (Object)id);
            return ValueSet.EMPTY_VALUE_SET;
        }
    }

    public static ValueSet findOpenEhrValueSet(String id, String[] values, String language) {
        try {
            if (ArrayUtils.isNotEmpty((Object[])values)) {
                return new ValueSet(id, "local", Arrays.stream(values).map(v -> new CodePhrase(new TerminologyId(id), v)).map(cp -> TerminologyProvider.convert(id, cp, language)).collect(Collectors.toSet()));
            }
            return new ValueSet(id, "all", LOCALIZED_TERMINOLOGIES.getDefault().codeSet(id).allCodes().stream().map(cp -> TerminologyProvider.convert(id, cp, language)).collect(Collectors.toSet()));
        }
        catch (RuntimeException e) {
            LOGGER.warn("Unknown  value {} in Terminology {}", (Object)values, (Object)id);
            return ValueSet.EMPTY_VALUE_SET;
        }
    }

    private static TermDefinition convert(String id, CodePhrase codePhrase, String language) {
        String value;
        try {
            value = LOCALIZED_TERMINOLOGIES.getDefault().terminology(id).rubricForCode(codePhrase.getCodeString(), language);
        }
        catch (RuntimeException e) {
            value = codePhrase.getCodeString();
        }
        return new TermDefinition(codePhrase.getCodeString(), value, value);
    }

    static {
        LOGGER = LoggerFactory.getLogger(TerminologyProvider.class);
        try {
            LOCALIZED_TERMINOLOGIES = new LocalizedTerminologies();
        }
        catch (Exception e) {
            throw new SdkException(e.getMessage(), (Throwable)e);
        }
    }
}

