/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.aql.containment;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.client.aql.containment.ContainmentExpression;
import org.ehrbase.client.aql.containment.ContainmentPath;
import org.ehrbase.client.aql.query.EntityQuery;

public class Containment
implements ContainmentExpression {
    private static final ArchieRMInfoLookup RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();
    private final Class<? extends Locatable> type;
    private final String archetype;
    private EntityQuery<?> query;
    private ContainmentExpression contains;
    private String typeName;

    public Containment(String archetype) {
        this.typeName = StringUtils.substringBetween((String)archetype, (String)"openEHR-EHR-", (String)".");
        if (StringUtils.isBlank((CharSequence)this.typeName)) {
            this.typeName = archetype;
            archetype = null;
        }
        this.archetype = archetype;
        this.type = "EHR".equals(this.typeName) ? null : RM_INFO_LOOKUP.getClass(this.typeName);
    }

    @Override
    public String buildAQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.typeName.toUpperCase()).append(" ").append(this.getVariableName());
        if (this.archetype != null) {
            sb.append("[").append(this.archetype).append("]");
        }
        if (this.contains != null) {
            sb.append(" contains ").append(this.contains.buildAQL());
        }
        return sb.toString();
    }

    public String getVariableName() {
        return this.query.buildVariabelName(this);
    }

    @Override
    public void bindQuery(EntityQuery<?> query) {
        this.query = query;
        if (this.contains != null) {
            this.contains.bindQuery(query);
        }
    }

    public Class<? extends Locatable> getType() {
        return this.type;
    }

    public ContainmentExpression getContains() {
        return this.contains;
    }

    public void setContains(ContainmentExpression contains) {
        this.contains = contains;
    }

    public ContainmentPath contains(Containment contains) {
        ContainmentPath tree = new ContainmentPath(this);
        return tree.contains(contains);
    }

    public ContainmentExpression contains(ContainmentExpression contains) {
        this.contains = contains;
        return this;
    }

    public String getTypeName() {
        return this.typeName;
    }
}

