/*
 * Decompiled with CFR 0.152.
 */
package com.eggheadgames.realmassethelper;

import android.content.Context;
import com.eggheadgames.realmassethelper.IRealmAssetHelperStorageListener;
import com.eggheadgames.realmassethelper.OsUtil;
import com.eggheadgames.realmassethelper.RealmAssetHelperStatus;

public class RealmAssetHelper {
    protected static RealmAssetHelper instance = new RealmAssetHelper();
    protected Context mContext;
    protected OsUtil mOsUtil;

    public static RealmAssetHelper getInstance(Context context) {
        RealmAssetHelper.instance.mContext = context;
        RealmAssetHelper.instance.mOsUtil = new OsUtil();
        return instance;
    }

    protected RealmAssetHelper() {
    }

    public void loadDatabaseToStorage(String databaseFolder, String databaseName, IRealmAssetHelperStorageListener listener) throws RuntimeException {
        this.mOsUtil.clearCache();
        if (this.mOsUtil.isEmpty(databaseName)) {
            throw new RuntimeException("The database name is empty");
        }
        if (!this.mOsUtil.isDatabaseAssetExists(this.mContext, databaseFolder, databaseName)) {
            throw new RuntimeException("An asset for requested database doesn't exist");
        }
        Integer currentDbVersion = this.mOsUtil.getCurrentDbVersion(this.mContext, databaseName);
        int assetsDbVersion = this.mOsUtil.getAssetsDbVersion(this.mContext, databaseFolder, databaseName);
        if (currentDbVersion == null) {
            String path = this.mOsUtil.loadDatabaseToLocalStorage(this.mContext, databaseFolder, databaseName);
            if (this.mOsUtil.isEmpty(path)) {
                throw new RuntimeException("Can't find copied file");
            }
            this.mOsUtil.storeDatabaseVersion(this.mContext, assetsDbVersion, databaseName);
            if (listener != null) {
                listener.onLoadedToStorage(path, RealmAssetHelperStatus.INSTALLED);
            }
        } else if (assetsDbVersion > currentDbVersion) {
            String path = this.mOsUtil.loadDatabaseToLocalStorage(this.mContext, databaseFolder, databaseName);
            if (this.mOsUtil.isEmpty(path)) {
                throw new RuntimeException("Can't find copied file");
            }
            this.mOsUtil.storeDatabaseVersion(this.mContext, assetsDbVersion, databaseName);
            if (listener != null) {
                listener.onLoadedToStorage(path, RealmAssetHelperStatus.UPDATED);
            }
        } else {
            String path = this.mOsUtil.getFileNameForDatabase(this.mContext, databaseName);
            if (this.mOsUtil.isEmpty(path)) {
                throw new RuntimeException("Can't find copied file");
            }
            if (listener != null) {
                listener.onLoadedToStorage(path, RealmAssetHelperStatus.IGNORED);
            }
        }
    }
}

