/*
 * Decompiled with CFR 0.152.
 */
package com.danikula.videocache;

import android.content.Context;
import android.os.Environment;
import java.io.File;

public final class StorageUtils {
    private static final String INDIVIDUAL_DIR_NAME = "video-cache";

    static File getIndividualCacheDirectory(Context context) {
        File cacheDir = StorageUtils.getCacheDirectory(context);
        return new File(cacheDir, INDIVIDUAL_DIR_NAME);
    }

    private static File getCacheDirectory(Context context) {
        File appCacheDir = null;
        if ("mounted".equals(Environment.getExternalStorageState())) {
            appCacheDir = context.getExternalCacheDir();
        }
        if (appCacheDir == null) {
            appCacheDir = context.getCacheDir();
        }
        if (appCacheDir == null) {
            String cacheDirPath = "/data/data/" + context.getPackageName() + "/cache/";
            appCacheDir = new File(cacheDirPath);
        }
        return appCacheDir;
    }

    public static boolean deleteFiles(File root) {
        File[] files = root.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory() || !f.exists() || f.delete()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            if (file.isFile()) {
                return file.delete();
            }
            String[] filePaths = file.list();
            if (filePaths != null) {
                for (String path : filePaths) {
                    StorageUtils.deleteFile(filePath + File.separator + path);
                }
            }
            return file.delete();
        }
        return true;
    }
}

