/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.widget;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.dueeeke.videoplayer.R;

public class CenterView
extends LinearLayout {
    private ImageView ivIcon;
    private TextView tvPercent;
    private ProgressBar proPercent;

    public CenterView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.setGravity(17);
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_center_window, (ViewGroup)this);
        this.ivIcon = (ImageView)view.findViewById(R.id.iv_icon);
        this.tvPercent = (TextView)view.findViewById(R.id.tv_percent);
        this.proPercent = (ProgressBar)view.findViewById(R.id.pro_percent);
    }

    public void setIcon(int icon) {
        if (this.ivIcon != null) {
            this.ivIcon.setImageResource(icon);
        }
    }

    public void setTextView(String text) {
        if (this.tvPercent != null) {
            this.tvPercent.setText((CharSequence)text);
        }
    }

    public void setProPercent(int percent) {
        if (this.proPercent != null) {
            this.proPercent.setProgress(percent);
        }
    }

    public void setProVisibility(int visibility) {
        if (this.proPercent != null) {
            this.proPercent.setVisibility(visibility);
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility != 0) {
            Animation animation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.anim_alpha_out);
            this.startAnimation(animation);
        }
    }
}

