/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.player;

import com.dueeeke.videoplayer.player.IjkVideoView;
import java.lang.ref.WeakReference;

public class VideoViewManager {
    private WeakReference<IjkVideoView> mPlayer;
    private static VideoViewManager sInstance;

    private VideoViewManager() {
    }

    public static synchronized VideoViewManager instance() {
        if (sInstance == null) {
            sInstance = new VideoViewManager();
        }
        return sInstance;
    }

    public void setCurrentVideoPlayer(IjkVideoView player) {
        this.mPlayer = new WeakReference<IjkVideoView>(player);
    }

    public IjkVideoView getCurrentVideoPlayer() {
        if (this.mPlayer == null) {
            return null;
        }
        return (IjkVideoView)this.mPlayer.get();
    }

    public void releaseVideoPlayer() {
        if (this.mPlayer != null && this.mPlayer.get() != null) {
            ((IjkVideoView)this.mPlayer.get()).release();
            this.mPlayer = null;
        }
    }

    public boolean onBackPressed() {
        return this.mPlayer != null && this.mPlayer.get() != null && ((IjkVideoView)this.mPlayer.get()).onBackPressed();
    }
}

