/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.player;

import android.content.Context;
import com.danikula.videocache.HttpProxyCacheServer;
import com.danikula.videocache.file.Md5FileNameGenerator;
import com.dueeeke.videoplayer.util.StorageUtil;
import java.io.File;

public class VideoCacheManager {
    private static HttpProxyCacheServer sharedProxy;

    private VideoCacheManager() {
    }

    public static HttpProxyCacheServer getProxy(Context context) {
        return sharedProxy == null ? (sharedProxy = VideoCacheManager.newProxy(context)) : sharedProxy;
    }

    private static HttpProxyCacheServer newProxy(Context context) {
        return new HttpProxyCacheServer.Builder(context).maxCacheSize(0x40000000L).build();
    }

    public static boolean clearAllCache(Context context) {
        File cacheDirectory = StorageUtil.getIndividualCacheDirectory(context);
        return StorageUtil.deleteFiles(cacheDirectory);
    }

    public static boolean clearDefaultCache(Context context, String url) {
        Md5FileNameGenerator md5FileNameGenerator = new Md5FileNameGenerator();
        String name = md5FileNameGenerator.generate(url);
        String pathTmp = StorageUtil.getIndividualCacheDirectory(context.getApplicationContext()).getAbsolutePath() + File.separator + name + ".download";
        String path = StorageUtil.getIndividualCacheDirectory(context.getApplicationContext()).getAbsolutePath() + File.separator + name;
        return StorageUtil.deleteFile(pathTmp) && StorageUtil.deleteFile(path);
    }
}

