/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.player;

import android.view.Surface;
import android.view.SurfaceHolder;
import com.dueeeke.videoplayer.listener.MediaEngineInterface;
import com.dueeeke.videoplayer.player.BaseMediaEngine;
import java.io.IOException;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;

public class IjkMediaEngine
extends BaseMediaEngine {
    public IjkMediaPlayer mMediaPlayer;
    private MediaEngineInterface mMediaEngineInterface;
    private IMediaPlayer.OnErrorListener onErrorListener = (iMediaPlayer, framework_err, impl_err) -> {
        if (this.mMediaEngineInterface != null) {
            this.mMediaEngineInterface.onError();
        }
        return true;
    };
    private IMediaPlayer.OnCompletionListener onCompletionListener = iMediaPlayer -> {
        if (this.mMediaEngineInterface != null) {
            this.mMediaEngineInterface.onCompletion();
        }
    };
    private IMediaPlayer.OnInfoListener onInfoListener = (iMediaPlayer, what, extra) -> {
        if (this.mMediaEngineInterface != null) {
            this.mMediaEngineInterface.onInfo(what, extra);
        }
        return true;
    };
    private IMediaPlayer.OnBufferingUpdateListener onBufferingUpdateListener = (iMediaPlayer, percent) -> {
        if (this.mMediaEngineInterface != null) {
            this.mMediaEngineInterface.onBufferingUpdate(percent);
        }
    };
    private IMediaPlayer.OnPreparedListener onPreparedListener = iMediaPlayer -> {
        if (this.mMediaEngineInterface != null) {
            this.mMediaEngineInterface.onPrepared();
        }
    };
    private IMediaPlayer.OnVideoSizeChangedListener onVideoSizeChangedListener = (iMediaPlayer, i, i1, i2, i3) -> {
        int videoWidth = iMediaPlayer.getVideoWidth();
        int videoHeight = iMediaPlayer.getVideoHeight();
        if (videoWidth != 0 && videoHeight != 0 && this.mMediaEngineInterface != null) {
            this.mMediaEngineInterface.onVideoSizeChanged(videoWidth, videoHeight);
        }
    };

    @Override
    public void start() {
        this.mMediaPlayer.start();
    }

    @Override
    public void initPlayer() {
        if (this.mMediaPlayer == null) {
            this.mMediaPlayer = new IjkMediaPlayer();
            this.mMediaPlayer.setOption(4, "mediacodec", 1L);
            this.mMediaPlayer.setOption(4, "mediacodec-auto-rotate", 1L);
            this.mMediaPlayer.setOption(4, "mediacodec-handle-resolution-change", 1L);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setOnErrorListener(this.onErrorListener);
            this.mMediaPlayer.setOnCompletionListener(this.onCompletionListener);
            this.mMediaPlayer.setOnInfoListener(this.onInfoListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.onBufferingUpdateListener);
            this.mMediaPlayer.setOnPreparedListener(this.onPreparedListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.onVideoSizeChangedListener);
        }
    }

    @Override
    public void setDataSource(String path) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.mMediaPlayer.setDataSource(path);
    }

    @Override
    public void pause() {
        this.mMediaPlayer.pause();
    }

    @Override
    public void stop() {
        this.mMediaPlayer.stop();
    }

    @Override
    public void prepareAsync() {
        this.mMediaPlayer.prepareAsync();
    }

    @Override
    public void reset() {
        this.mMediaPlayer.reset();
        this.mMediaPlayer.setOnVideoSizeChangedListener(this.onVideoSizeChangedListener);
    }

    @Override
    public boolean isPlaying() {
        return this.mMediaPlayer.isPlaying();
    }

    @Override
    public void seekTo(long time) {
        this.mMediaPlayer.seekTo((long)((int)time));
    }

    @Override
    public void release() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.release();
        }
    }

    @Override
    public long getCurrentPosition() {
        return this.mMediaPlayer.getCurrentPosition();
    }

    @Override
    public long getDuration() {
        return this.mMediaPlayer.getDuration();
    }

    @Override
    public void setSurface(Surface surface) {
        this.mMediaPlayer.setSurface(surface);
    }

    @Override
    public void setDisplay(SurfaceHolder holder) {
        this.mMediaPlayer.setDisplay(holder);
    }

    @Override
    public void setVolume(int v1, int v2) {
        this.mMediaPlayer.setVolume((float)v1, (float)v2);
    }

    public void setMediaEngineInterface(MediaEngineInterface mediaEngineInterface) {
        this.mMediaEngineInterface = mediaEngineInterface;
    }
}

