/*
 * Decompiled with CFR 0.152.
 */
package dreamspace.ads.sdk.gdpr;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.google.android.gms.ads.MobileAds;
import com.google.android.ump.ConsentInformation;
import com.google.android.ump.ConsentRequestParameters;
import com.google.android.ump.UserMessagingPlatform;
import java.util.concurrent.atomic.AtomicBoolean;

public class UMP {
    private static final String TAG = UMP.class.getSimpleName();
    private ConsentInformation consentInformation;
    private final AtomicBoolean isMobileAdsInitializeCalled = new AtomicBoolean(false);
    private Activity activity;

    public UMP(Activity activity) {
        this.activity = activity;
    }

    public void loadShowConsentForm() {
        ConsentRequestParameters params = new ConsentRequestParameters.Builder().setTagForUnderAgeOfConsent(false).build();
        this.consentInformation = UserMessagingPlatform.getConsentInformation((Context)this.activity);
        this.consentInformation.requestConsentInfoUpdate(this.activity, params, () -> UserMessagingPlatform.loadAndShowConsentFormIfRequired((Activity)this.activity, loadAndShowError -> {
            if (loadAndShowError != null) {
                Log.w((String)TAG, (String)String.format("%s: %s", loadAndShowError.getErrorCode(), loadAndShowError.getMessage()));
            }
            if (this.consentInformation.canRequestAds()) {
                this.initializeMobileAdsSdk();
            }
        }), requestConsentError -> Log.w((String)TAG, (String)String.format("%s: %s", requestConsentError.getErrorCode(), requestConsentError.getMessage())));
        if (this.consentInformation.canRequestAds()) {
            this.initializeMobileAdsSdk();
        }
    }

    private void initializeMobileAdsSdk() {
        if (this.isMobileAdsInitializeCalled.getAndSet(true)) {
            return;
        }
        MobileAds.initialize((Context)this.activity);
    }
}

