/*
 * Decompiled with CFR 0.152.
 */
package dreamspace.ads.sdk.format;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.LevelPlayInterstitialListener;
import dreamspace.ads.sdk.AdConfig;
import dreamspace.ads.sdk.AdNetwork;
import dreamspace.ads.sdk.data.AdNetworkType;
import dreamspace.ads.sdk.listener.ActivityListener;
import dreamspace.ads.sdk.listener.AdOpenListener;
import java.util.Date;

public class OpenAppAdFormat {
    private static final String TAG = AdNetwork.class.getSimpleName();
    private final Activity activity;
    private static boolean openAppSplashFinished = false;
    private static boolean isLoadingAd = false;
    public static boolean isShowingAd = false;
    private static long loadTime = 0L;
    private static long lastShowTime = 0L;
    public static int last_open_app_index = -1;
    public static AppOpenAd ad_admob_appOpenAd = null;
    public static AppOpenAd ad_manager_appOpenAd = null;
    private static ActivityListener activityListener = null;

    public OpenAppAdFormat(Activity activity) {
        this.activity = activity;
        OpenAppAdFormat.initActivityListener(activity.getApplication());
    }

    public static void initActivityListener(Application application) {
        activityListener = new ActivityListener(application);
    }

    public void loadAndShowOpenAppAd(final int ad_index, final int retry_count, final AdOpenListener listener) {
        if (retry_count > AdConfig.retry_from_start_max) {
            this.openAppSplashFinish(listener);
            return;
        }
        final AdNetworkType type = AdConfig.ad_networks[ad_index];
        if (type == AdNetworkType.ADMOB || type == AdNetworkType.FAN_BIDDING_ADMOB) {
            Log.d((String)TAG, (String)((Object)((Object)type) + " loadAndShowOpenAppAd"));
            AdRequest request = new AdRequest.Builder().build();
            String unit_id = AdConfig.ad_admob_open_app_unit_id;
            AppOpenAd.load((Context)this.activity, (String)unit_id, (AdRequest)request, (AppOpenAd.AppOpenAdLoadCallback)new AppOpenAd.AppOpenAdLoadCallback(){

                public void onAdLoaded(@NonNull AppOpenAd ad) {
                    super.onAdLoaded((Object)ad);
                    Log.d((String)TAG, (String)((Object)((Object)type) + " Open App loaded _ splash"));
                    loadTime = new Date().getTime();
                    ad.setFullScreenContentCallback(new FullScreenContentCallback(){

                        public void onAdDismissedFullScreenContent() {
                            super.onAdDismissedFullScreenContent();
                            OpenAppAdFormat.this.openAppSplashFinish(listener);
                        }

                        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                            super.onAdFailedToShowFullScreenContent(adError);
                            OpenAppAdFormat.this.openAppSplashFinish(listener);
                        }
                    });
                    ad.show(OpenAppAdFormat.this.activity);
                }

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    OpenAppAdFormat.this.retryLoadAndShowOpenAppAd(ad_index, retry_count, listener);
                    Log.d((String)TAG, (String)((Object)((Object)type) + " Open App load failed _ splash : " + loadAdError.getMessage()));
                }
            });
        } else if (type == AdNetworkType.MANAGER || type == AdNetworkType.FAN_BIDDING_AD_MANAGER) {
            AdManagerAdRequest adManagerAdRequest = new AdManagerAdRequest.Builder().build();
            AppOpenAd.load((Context)this.activity, (String)AdConfig.ad_manager_open_app_unit_id, (AdRequest)adManagerAdRequest, (AppOpenAd.AppOpenAdLoadCallback)new AppOpenAd.AppOpenAdLoadCallback(){

                public void onAdLoaded(@NonNull AppOpenAd ad) {
                    Log.d((String)TAG, (String)((Object)((Object)type) + " Open App loaded _ splash"));
                    loadTime = new Date().getTime();
                    ad.setFullScreenContentCallback(new FullScreenContentCallback(){

                        public void onAdDismissedFullScreenContent() {
                            super.onAdDismissedFullScreenContent();
                            OpenAppAdFormat.this.openAppSplashFinish(listener);
                        }

                        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                            super.onAdFailedToShowFullScreenContent(adError);
                            OpenAppAdFormat.this.openAppSplashFinish(listener);
                        }
                    });
                    ad.show(OpenAppAdFormat.this.activity);
                }

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    Log.d((String)TAG, (String)((Object)((Object)type) + " Open App load failed _ splash : " + loadAdError.getMessage()));
                    OpenAppAdFormat.this.retryLoadAndShowOpenAppAd(ad_index, retry_count, listener);
                }
            });
        } else if ((type == AdNetworkType.IRONSOURCE || type == AdNetworkType.FAN_BIDDING_IRONSOURCE) && AdConfig.ad_replace_unsupported_open_app_with_interstitial_on_splash) {
            IronSource.setLevelPlayInterstitialListener((LevelPlayInterstitialListener)new LevelPlayInterstitialListener(){

                public void onAdReady(AdInfo adInfo) {
                    Log.d((String)TAG, (String)((Object)((Object)type) + " Open App loaded _ splash"));
                    loadTime = new Date().getTime();
                    IronSource.showInterstitial((String)AdConfig.ad_ironsource_interstitial_unit_id);
                }

                public void onAdLoadFailed(IronSourceError ironSourceError) {
                    Log.d((String)TAG, (String)((Object)((Object)type) + " Open App load failed _ splash : " + ironSourceError.getErrorMessage()));
                    OpenAppAdFormat.this.retryLoadAndShowOpenAppAd(ad_index, retry_count, listener);
                }

                public void onAdOpened(AdInfo adInfo) {
                }

                public void onAdShowSucceeded(AdInfo adInfo) {
                }

                public void onAdShowFailed(IronSourceError ironSourceError, AdInfo adInfo) {
                    OpenAppAdFormat.this.openAppSplashFinish(listener);
                }

                public void onAdClicked(AdInfo adInfo) {
                }

                public void onAdClosed(AdInfo adInfo) {
                    OpenAppAdFormat.this.openAppSplashFinish(listener);
                }
            });
            IronSource.loadInterstitial();
        } else {
            this.openAppSplashFinish(listener);
        }
    }

    public void retryLoadAndShowOpenAppAd(int ad_index, int retry_count, AdOpenListener listener) {
        int adIndex = ad_index + 1;
        int finalRetry = retry_count;
        if (adIndex > AdConfig.ad_networks.length - 1) {
            adIndex = 0;
            ++finalRetry;
        }
        int _adIndex = adIndex;
        int _finalRetry = finalRetry;
        Log.d((String)TAG, (String)("retryLoadAndShowOpenAppAd ad_index : " + _adIndex + " retry_count : " + _finalRetry));
        new Handler(this.activity.getMainLooper()).postDelayed(() -> this.loadAndShowOpenAppAd(_adIndex, _finalRetry, listener), 500L);
    }

    public void openAppSplashFinish(AdOpenListener listener) {
        lastShowTime = new Date().getTime();
        if (listener != null) {
            listener.onFinish();
        }
    }

    public static void loadOpenAppAd(final Context context, final int ad_index, final int retry_count) {
        if (retry_count > AdConfig.retry_from_start_max) {
            isLoadingAd = false;
            return;
        }
        last_open_app_index = ad_index;
        final AdNetworkType type = AdConfig.ad_networks[ad_index];
        isLoadingAd = true;
        if (type == AdNetworkType.ADMOB || type == AdNetworkType.FAN_BIDDING_ADMOB) {
            Log.d((String)TAG, (String)((Object)((Object)type) + " loadOpenAppAd"));
            AdRequest request = new AdRequest.Builder().build();
            String unit_id = AdConfig.ad_admob_open_app_unit_id;
            AppOpenAd.load((Context)context, (String)unit_id, (AdRequest)request, (AppOpenAd.AppOpenAdLoadCallback)new AppOpenAd.AppOpenAdLoadCallback(){

                public void onAdLoaded(@NonNull AppOpenAd ad) {
                    super.onAdLoaded((Object)ad);
                    isLoadingAd = false;
                    Log.d((String)TAG, (String)((Object)((Object)type) + " Open App loaded"));
                    ad_admob_appOpenAd = ad;
                    loadTime = new Date().getTime();
                }

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    isLoadingAd = false;
                    OpenAppAdFormat.retryLoadOpenAppAd(context, ad_index, retry_count);
                    Log.d((String)TAG, (String)((Object)((Object)type) + " Open App load failed : " + loadAdError.getMessage()));
                }
            });
        } else if (type == AdNetworkType.MANAGER || type == AdNetworkType.FAN_BIDDING_AD_MANAGER) {
            AdManagerAdRequest adManagerAdRequest = new AdManagerAdRequest.Builder().build();
            AppOpenAd.load((Context)context, (String)AdConfig.ad_manager_open_app_unit_id, (AdRequest)adManagerAdRequest, (AppOpenAd.AppOpenAdLoadCallback)new AppOpenAd.AppOpenAdLoadCallback(){

                public void onAdLoaded(@NonNull AppOpenAd ad) {
                    Log.d((String)TAG, (String)((Object)((Object)type) + " Open App loaded"));
                    isLoadingAd = false;
                    ad_manager_appOpenAd = ad;
                    loadTime = new Date().getTime();
                }

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    Log.d((String)TAG, (String)((Object)((Object)type) + " Open App load failed : " + loadAdError.getMessage()));
                    isLoadingAd = false;
                    OpenAppAdFormat.retryLoadOpenAppAd(context, ad_index, retry_count);
                }
            });
        } else {
            isLoadingAd = false;
        }
    }

    public static void retryLoadOpenAppAd(Context context, int ad_index, int retry_count) {
        int adIndex = ad_index + 1;
        int finalRetry = retry_count;
        if (adIndex > AdConfig.ad_networks.length - 1) {
            adIndex = 0;
            ++finalRetry;
        }
        int _adIndex = adIndex;
        int _finalRetry = finalRetry;
        Log.d((String)TAG, (String)("retryLoadOpenAppAd ad_index : " + _adIndex + " retry_count : " + _finalRetry));
        new Handler(context.getMainLooper()).postDelayed(() -> OpenAppAdFormat.loadOpenAppAd(context, _adIndex, _finalRetry), 500L);
    }

    public static void showOpenAppAd(Context context) {
        Log.d((String)TAG, (String)"showOpenAppAd start");
        if (isLoadingAd) {
            Log.d((String)TAG, (String)"Open app still loading");
            return;
        }
        if (!OpenAppAdFormat.wasLoadTimeLessThanNHoursAgo(4L)) {
            OpenAppAdFormat.loadOpenAppAd(context, 0, 0);
            Log.d((String)TAG, (String)"showOpenAppAd : wasLoadTimeLessThanNHoursAgo");
            return;
        }
        if (!OpenAppAdFormat.wasShowTimeMoreNSecondAgo(10L)) {
            Log.d((String)TAG, (String)"showOpenAppAd : wasShowTimeMoreNMinuteAgo");
            return;
        }
        if (activityListener == null || ActivityListener.currentActivity == null) {
            Log.d((String)TAG, (String)"showOpenAppAd : activityListener null");
            return;
        }
        AdNetworkType type = AdConfig.ad_networks[last_open_app_index];
        lastShowTime = new Date().getTime();
        if (type == AdNetworkType.ADMOB || type == AdNetworkType.FAN_BIDDING_ADMOB) {
            if (ad_admob_appOpenAd == null) {
                return;
            }
            ad_admob_appOpenAd.show(ActivityListener.currentActivity);
        } else if (type == AdNetworkType.MANAGER || type == AdNetworkType.FAN_BIDDING_AD_MANAGER) {
            if (ad_manager_appOpenAd == null) {
                return;
            }
            ad_manager_appOpenAd.show(ActivityListener.currentActivity);
        }
        Log.d((String)TAG, (String)((Object)((Object)type) + " showOpenAppAd"));
    }

    private static boolean wasLoadTimeLessThanNHoursAgo(long numHours) {
        long numMilliSecondsPerHour;
        long dateDifference = new Date().getTime() - loadTime;
        return dateDifference < (numMilliSecondsPerHour = 3600000L) * numHours;
    }

    private static boolean wasShowTimeMoreNSecondAgo(long second) {
        long numMilliSecondsPerSecond;
        long difference = new Date().getTime() - lastShowTime;
        return difference > (numMilliSecondsPerSecond = 1000L) * second;
    }
}

