/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.paukov.combinatorics3.SimpleCombinationGenerator;

class SimpleCombinationIterator<T>
implements Iterator<List<T>> {
    private final SimpleCombinationGenerator<T> generator;
    private final List<T> currentCombination = new ArrayList<T>();
    private final int[] bitVector;
    private long currentIndex;
    private int endIndex = 0;

    SimpleCombinationIterator(SimpleCombinationGenerator<T> generator) {
        this.generator = generator;
        this.bitVector = new int[generator.combinationLength + 1];
        for (int i = 0; i <= generator.combinationLength; ++i) {
            this.bitVector[i] = i;
        }
        if (generator.originalVector.size() > 0) {
            this.endIndex = 1;
        }
        this.currentIndex = 0L;
    }

    private void setValue(int index, T value) {
        if (index < this.currentCombination.size()) {
            this.currentCombination.set(index, value);
        } else {
            this.currentCombination.add(index, value);
        }
    }

    @Override
    public boolean hasNext() {
        return this.endIndex != 0 && this.generator.combinationLength <= this.generator.originalVector.size();
    }

    @Override
    public List<T> next() {
        int i;
        ++this.currentIndex;
        for (i = 1; i <= this.generator.combinationLength; ++i) {
            int index = this.bitVector[i] - 1;
            if (this.generator.originalVector.size() <= 0) continue;
            this.setValue(i - 1, this.generator.originalVector.get(index));
        }
        this.endIndex = this.generator.combinationLength;
        while (this.bitVector[this.endIndex] == this.generator.originalVector.size() - this.generator.combinationLength + this.endIndex) {
            --this.endIndex;
            if (this.endIndex != 0) continue;
        }
        int n = this.endIndex;
        this.bitVector[n] = this.bitVector[n] + 1;
        for (i = this.endIndex + 1; i <= this.generator.combinationLength; ++i) {
            this.bitVector[i] = this.bitVector[i - 1] + 1;
        }
        return new ArrayList<T>(this.currentCombination);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "SimpleCombinationIterator=[#" + this.currentIndex + ", " + this.currentCombination + "]";
    }
}

