/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.paukov.combinatorics3.IntegerPartitionGenerator;

class IntegerPartitionIterator
implements Iterator<List<Integer>> {
    private final InternalVector vector1;
    private final InternalVector vector2;
    private List<Integer> currentPartition = null;
    private long currentIndex = 0L;
    private int stopIndex = 1;

    IntegerPartitionIterator(IntegerPartitionGenerator generator) {
        if (generator.value > 0) {
            this.vector1 = new InternalVector(generator.value, 0, 0, generator.value);
            this.vector2 = new InternalVector(generator.value, 0, generator.value + 1, 1);
        } else {
            this.stopIndex = 0;
            this.vector1 = new InternalVector(1, 0, 0, 0);
            this.vector2 = new InternalVector(1, 0, 0, 0);
        }
    }

    @Override
    public boolean hasNext() {
        return this.stopIndex != 0;
    }

    @Override
    public List<Integer> next() {
        ++this.currentIndex;
        this.currentPartition = IntegerPartitionIterator.createPartition(this.stopIndex, this.vector1, this.vector2);
        int sum = this.vector1.get(this.stopIndex) * this.vector2.get(this.stopIndex);
        if (this.vector1.get(this.stopIndex) == 1) {
            --this.stopIndex;
            sum += this.vector1.get(this.stopIndex) * this.vector2.get(this.stopIndex);
        }
        if (this.vector2.get(this.stopIndex - 1) == this.vector2.get(this.stopIndex) + 1) {
            --this.stopIndex;
            this.vector1.set(this.stopIndex, this.vector1.get(this.stopIndex) + 1);
        } else {
            this.vector2.set(this.stopIndex, this.vector2.get(this.stopIndex) + 1);
            this.vector1.set(this.stopIndex, 1);
        }
        if (sum > this.vector2.get(this.stopIndex)) {
            this.vector2.set(this.stopIndex + 1, 1);
            this.vector1.set(this.stopIndex + 1, sum - this.vector2.get(this.stopIndex));
            ++this.stopIndex;
        }
        return this.currentPartition;
    }

    private static List<Integer> createPartition(int index, InternalVector vector1, InternalVector vector) {
        ArrayList<Integer> partition = new ArrayList<Integer>();
        for (int i = 1; i <= index; ++i) {
            for (int j = 0; j < vector1.get(i); ++j) {
                partition.add(vector.get(i));
            }
        }
        return partition;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "IntegerPartitionIterator=[#" + this.currentIndex + ", " + this.currentPartition + "]";
    }

    private static class InternalVector {
        final int[] array;

        InternalVector(int size, int value0, int value1, int value2) {
            this.array = new int[size + 2];
            this.array[0] = value0;
            this.array[1] = value1;
            this.array[2] = value2;
        }

        int get(int index) {
            return this.array[index + 1];
        }

        void set(int index, int value) {
            this.array[index + 1] = value;
        }
    }
}

