/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.paukov.combinatorics3.SimpleCombinationGenerator;

class SimpleCombinationIterator<T>
implements Iterator<List<T>> {
    private final SimpleCombinationGenerator<T> generator;
    private List<T> currentSimpleCombination = null;
    private long currentIndex = 0L;
    private final int lengthN;
    private final int lengthK;
    private int[] bitVector = null;
    private int endIndex = 0;

    SimpleCombinationIterator(SimpleCombinationGenerator<T> generator) {
        this.generator = generator;
        this.lengthN = generator.originalVector.size();
        this.lengthK = generator.combinationLength;
        this.currentSimpleCombination = new ArrayList<T>();
        this.bitVector = new int[this.lengthK + 1];
        for (int i = 0; i <= this.lengthK; ++i) {
            this.bitVector[i] = i;
        }
        if (this.lengthN > 0) {
            this.endIndex = 1;
        }
        this.currentIndex = 0L;
    }

    @Override
    public boolean hasNext() {
        return this.endIndex != 0 && this.lengthK <= this.lengthN;
    }

    @Override
    public List<T> next() {
        int i;
        ++this.currentIndex;
        for (i = 1; i <= this.lengthK; ++i) {
            int index = this.bitVector[i] - 1;
            if (this.generator.originalVector.size() <= 0) continue;
            SimpleCombinationIterator.setValue(this.currentSimpleCombination, i - 1, this.generator.originalVector.get(index));
        }
        this.endIndex = this.lengthK;
        while (this.bitVector[this.endIndex] == this.lengthN - this.lengthK + this.endIndex) {
            --this.endIndex;
            if (this.endIndex != 0) continue;
        }
        int n = this.endIndex;
        this.bitVector[n] = this.bitVector[n] + 1;
        for (i = this.endIndex + 1; i <= this.lengthK; ++i) {
            this.bitVector[i] = this.bitVector[i - 1] + 1;
        }
        return new ArrayList<T>(this.currentSimpleCombination);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "SimpleCombinationIterator=[#" + this.currentIndex + ", " + this.currentSimpleCombination + "]";
    }

    private static <T> void setValue(List<T> list, int index, T value) {
        if (index < list.size()) {
            list.set(index, value);
        } else {
            list.add(index, value);
        }
    }
}

