/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.paukov.combinatorics3.CartesianProductGenerator;

class CartesianProductIterator<T>
implements Iterator<List<T>> {
    private List<List<T>> vector;
    private final int vectorSize;
    private int nextIndex;
    private final int[] indices;
    private List<T> current;
    private int index = 0;
    private boolean hasEmptyList = false;

    CartesianProductIterator(CartesianProductGenerator<T> generator) {
        this.vector = generator.originalVector;
        this.vectorSize = generator.originalVector.size();
        this.nextIndex = this.vectorSize - 1;
        this.indices = new int[this.vectorSize];
        for (int i = 0; i < this.vectorSize; ++i) {
            this.hasEmptyList = this.hasEmptyList || this.vector.get(i).size() == 0;
        }
    }

    @Override
    public boolean hasNext() {
        return !this.hasEmptyList && this.nextIndex >= 0;
    }

    @Override
    public List<T> next() {
        if (this.index == 0) {
            return this.generateCartesianProduct();
        }
        if (this.nextIndex < 0) {
            throw new RuntimeException("No more cartesian product.");
        }
        int n = this.nextIndex;
        this.indices[n] = this.indices[n] + 1;
        for (int i = this.nextIndex + 1; i < this.vectorSize; ++i) {
            this.indices[i] = 0;
        }
        return this.generateCartesianProduct();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "CartesianProductIterator=[#" + this.index + ", " + this.current + "]";
    }

    private List<T> generateCartesianProduct() {
        this.current = new ArrayList<T>();
        for (int i = 0; i < this.vectorSize; ++i) {
            this.current.add(this.vector.get(i).get(this.indices[i]));
        }
        this.checkIfHasNextCartesianProduct();
        ++this.index;
        return this.current;
    }

    private void checkIfHasNextCartesianProduct() {
        this.nextIndex = this.vectorSize - 1;
        while (this.nextIndex >= 0 && this.indices[this.nextIndex] + 1 >= this.vector.get(this.nextIndex).size()) {
            --this.nextIndex;
        }
    }
}

