/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.protobuf.util;

import com.github.dozermapper.core.MappingException;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.util.MappingUtils;
import com.google.common.base.CaseFormat;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class ProtoUtils {
    private ProtoUtils() {
    }

    public static Message.Builder getBuilder(Class<? extends Message> clazz) {
        Message.Builder protoBuilder;
        try {
            Method newBuilderMethod = clazz.getMethod("newBuilder", new Class[0]);
            protoBuilder = (Message.Builder)newBuilderMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new MappingException("Failed to create Message.Builder for " + clazz.getCanonicalName(), (Throwable)e);
        }
        return protoBuilder;
    }

    public static List<Descriptors.FieldDescriptor> getFieldDescriptors(Class<? extends Message> clazz) {
        Message.Builder protoBuilder = ProtoUtils.getBuilder(clazz);
        return ProtoUtils.getFieldDescriptors(protoBuilder);
    }

    private static List<Descriptors.FieldDescriptor> getFieldDescriptors(Message.Builder protoBuilder) {
        return protoBuilder.getDescriptorForType().getFields();
    }

    public static Descriptors.FieldDescriptor getFieldDescriptor(Class<? extends Message> clazz, String fieldName) {
        List<Descriptors.FieldDescriptor> protoFieldDescriptors = ProtoUtils.getFieldDescriptors(clazz);
        for (Descriptors.FieldDescriptor descriptor : protoFieldDescriptors) {
            if (!ProtoUtils.sameField(fieldName, descriptor.getName())) continue;
            return descriptor;
        }
        return null;
    }

    private static boolean sameField(String fieldName, String protoFieldName) {
        if (fieldName.equals(protoFieldName)) {
            return true;
        }
        return fieldName.equals(ProtoUtils.toCamelCase(protoFieldName));
    }

    public static Object getFieldValue(Object message, String fieldName) {
        Object answer = null;
        Map fieldsMap = ((Message)message).getAllFields();
        for (Map.Entry field : fieldsMap.entrySet()) {
            if (!ProtoUtils.sameField(fieldName, ((Descriptors.FieldDescriptor)field.getKey()).getName())) continue;
            if (((Descriptors.FieldDescriptor)field.getKey()).isMapField()) {
                String propertyName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                String methodName = String.format("get%sMap", propertyName);
                try {
                    Method mapGetter = message.getClass().getMethod(methodName, new Class[0]);
                    answer = mapGetter.invoke(message, new Object[0]);
                    break;
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new MappingException("Could not introspect map field with method " + methodName, (Throwable)e);
                }
            }
            answer = field.getValue();
            break;
        }
        return answer;
    }

    public static Class<?> getJavaClass(Descriptors.FieldDescriptor descriptor, BeanContainer beanContainer) {
        if (descriptor.isMapField()) {
            return Map.class;
        }
        if (descriptor.isRepeated()) {
            return List.class;
        }
        return ProtoUtils.getJavaClassIgnoreRepeated(descriptor, beanContainer);
    }

    public static Class<?> getJavaGenericClassForCollection(Descriptors.FieldDescriptor descriptor, BeanContainer beanContainer) {
        if (!descriptor.isRepeated()) {
            return null;
        }
        return ProtoUtils.getJavaClassIgnoreRepeated(descriptor, beanContainer);
    }

    private static Class<?> getJavaClassIgnoreRepeated(Descriptors.FieldDescriptor descriptor, BeanContainer beanContainer) {
        switch (descriptor.getJavaType()) {
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case STRING: {
                return String.class;
            }
            case BYTE_STRING: {
                return ByteString.class;
            }
            case ENUM: {
                return ProtoUtils.getEnumClassByEnumDescriptor(descriptor.getEnumType(), beanContainer);
            }
            case MESSAGE: {
                return MappingUtils.loadClass((String)StringUtils.join((Object[])ProtoUtils.getFullyQualifiedClassName(descriptor.getMessageType().getContainingType(), descriptor.getMessageType().getFile().getOptions(), descriptor.getMessageType().getName()), (char)'.'), (BeanContainer)beanContainer);
            }
        }
        throw new MappingException("Unable to find " + descriptor.getJavaType());
    }

    private static String[] getFullyQualifiedClassName(Descriptors.Descriptor container, DescriptorProtos.FileOptions fileOpts, String name) {
        if (fileOpts.getJavaMultipleFiles()) {
            LinkedList<String> fqnSegments = new LinkedList<String>();
            fqnSegments.push(name);
            while (container != null) {
                fqnSegments.push(container.getName());
                container = container.getContainingType();
            }
            fqnSegments.push(fileOpts.getJavaPackage());
            return fqnSegments.toArray(new String[0]);
        }
        return new String[]{fileOpts.getJavaPackage(), fileOpts.getJavaOuterClassname(), name};
    }

    private static Class<? extends Enum> getEnumClassByEnumDescriptor(Descriptors.EnumDescriptor descriptor, BeanContainer beanContainer) {
        String name = StringUtils.join((Object[])ProtoUtils.getFullyQualifiedClassName(descriptor.getContainingType(), descriptor.getFile().getOptions(), descriptor.getName()), (char)'.');
        return MappingUtils.loadClass((String)name, (BeanContainer)beanContainer);
    }

    public static Object wrapEnums(Object value) {
        if (value instanceof ProtocolMessageEnum) {
            return ((ProtocolMessageEnum)value).getValueDescriptor();
        }
        if (value instanceof List) {
            ArrayList<Object> modifiedList = new ArrayList<Object>(((List)value).size());
            for (Object element : (List)value) {
                modifiedList.add(ProtoUtils.wrapEnums(element));
            }
            return modifiedList;
        }
        return value;
    }

    public static Object unwrapEnums(Object value, BeanContainer beanContainer) {
        if (value instanceof Descriptors.EnumValueDescriptor) {
            Descriptors.EnumValueDescriptor descriptor = (Descriptors.EnumValueDescriptor)value;
            Class<? extends Enum> enumClass = ProtoUtils.getEnumClassByEnumDescriptor(descriptor.getType(), beanContainer);
            for (Enum enumValue : enumClass.getEnumConstants()) {
                if (!((Descriptors.EnumValueDescriptor)value).getName().equals(enumValue.name())) continue;
                return enumValue;
            }
            return null;
        }
        if (value instanceof Collection) {
            Collection valueCollection = (Collection)value;
            ArrayList<Object> modifiedList = new ArrayList<Object>(valueCollection.size());
            for (Object element : valueCollection) {
                modifiedList.add(ProtoUtils.unwrapEnums(element, beanContainer));
            }
            return modifiedList;
        }
        return value;
    }

    public static String toCamelCase(String name) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
    }
}

