/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.protobuf.util;

import com.google.common.base.CaseFormat;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dozer.config.BeanContainer;
import org.dozer.util.MappingUtils;

public final class ProtoUtils {
    private ProtoUtils() {
    }

    public static Message.Builder getBuilder(Class<? extends Message> clazz) {
        Message.Builder protoBuilder;
        try {
            Method newBuilderMethod = clazz.getMethod("newBuilder", new Class[0]);
            protoBuilder = (Message.Builder)newBuilderMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            MappingUtils.throwMappingException((Throwable)e);
            return null;
        }
        return protoBuilder;
    }

    public static List<Descriptors.FieldDescriptor> getFieldDescriptors(Class<? extends Message> clazz) {
        Message.Builder protoBuilder = ProtoUtils.getBuilder(clazz);
        return ProtoUtils.getFieldDescriptors(protoBuilder);
    }

    public static List<Descriptors.FieldDescriptor> getFieldDescriptors(Message.Builder protoBuilder) {
        return protoBuilder.getDescriptorForType().getFields();
    }

    public static Descriptors.FieldDescriptor getFieldDescriptor(Class<? extends Message> clazz, String fieldName) {
        List<Descriptors.FieldDescriptor> protoFieldDescriptors = ProtoUtils.getFieldDescriptors(clazz);
        for (Descriptors.FieldDescriptor descriptor : protoFieldDescriptors) {
            if (!ProtoUtils.sameField(fieldName, descriptor.getName())) continue;
            return descriptor;
        }
        return null;
    }

    private static boolean sameField(String fieldName, String protoFieldName) {
        if (fieldName.equals(protoFieldName)) {
            return true;
        }
        return fieldName.equals(ProtoUtils.toCamelCase(protoFieldName));
    }

    public static Object getFieldValue(Object message, String fieldName) {
        Map fieldsMap = ((Message)message).getAllFields();
        for (Map.Entry field : fieldsMap.entrySet()) {
            if (!ProtoUtils.sameField(fieldName, ((Descriptors.FieldDescriptor)field.getKey()).getName())) continue;
            if (((Descriptors.FieldDescriptor)field.getKey()).isMapField()) {
                String propertyName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                String methodName = String.format("get%sMap", propertyName);
                try {
                    Method mapGetter = message.getClass().getMethod(methodName, new Class[0]);
                    return mapGetter.invoke(message, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not introspect map field with method " + methodName, e);
                }
            }
            return field.getValue();
        }
        return null;
    }

    public static Class<?> getJavaClass(Descriptors.FieldDescriptor descriptor, BeanContainer beanContainer) {
        if (descriptor.isMapField()) {
            return Map.class;
        }
        if (descriptor.isRepeated()) {
            return List.class;
        }
        return ProtoUtils.getJavaClassIgnoreRepeated(descriptor, beanContainer);
    }

    public static Class<?> getJavaGenericClassForCollection(Descriptors.FieldDescriptor descriptor, BeanContainer beanContainer) {
        if (!descriptor.isRepeated()) {
            return null;
        }
        return ProtoUtils.getJavaClassIgnoreRepeated(descriptor, beanContainer);
    }

    private static Class<?> getJavaClassIgnoreRepeated(Descriptors.FieldDescriptor descriptor, BeanContainer beanContainer) {
        switch (descriptor.getJavaType()) {
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case STRING: {
                return String.class;
            }
            case BYTE_STRING: {
                return ByteString.class;
            }
            case ENUM: {
                return ProtoUtils.getEnumClassByEnumDescriptor(descriptor.getEnumType(), beanContainer);
            }
            case MESSAGE: {
                return MappingUtils.loadClass((String)StringUtils.join((Object[])ProtoUtils.getFullyQualifiedClassName(descriptor.getMessageType().getFile().getOptions(), descriptor.getMessageType().getName()), (char)'.'), (BeanContainer)beanContainer);
            }
        }
        throw new RuntimeException();
    }

    private static String[] getFullyQualifiedClassName(DescriptorProtos.FileOptions options, String name) {
        return new String[]{options.getJavaPackage(), options.getJavaOuterClassname(), name};
    }

    private static Class<? extends Enum> getEnumClassByEnumDescriptor(Descriptors.EnumDescriptor descriptor, BeanContainer beanContainer) {
        return MappingUtils.loadClass((String)StringUtils.join((Object[])ProtoUtils.getFullyQualifiedClassName(descriptor.getFile().getOptions(), descriptor.getName()), (char)'.'), (BeanContainer)beanContainer);
    }

    public static Object wrapEnums(Object value) {
        if (value instanceof ProtocolMessageEnum) {
            return ((ProtocolMessageEnum)value).getValueDescriptor();
        }
        if (value instanceof List) {
            ArrayList<Object> modifiedList = new ArrayList<Object>(((List)value).size());
            for (Object element : (List)value) {
                modifiedList.add(ProtoUtils.wrapEnums(element));
            }
            return modifiedList;
        }
        return value;
    }

    public static Object unwrapEnums(Object value, BeanContainer beanContainer) {
        if (value instanceof Descriptors.EnumValueDescriptor) {
            Enum[] enumValues;
            Descriptors.EnumValueDescriptor descriptor = (Descriptors.EnumValueDescriptor)value;
            Class<? extends Enum> enumClass = ProtoUtils.getEnumClassByEnumDescriptor(descriptor.getType(), beanContainer);
            for (Enum enumValue : enumValues = enumClass.getEnumConstants()) {
                if (!((Descriptors.EnumValueDescriptor)value).getName().equals(enumValue.name())) continue;
                return enumValue;
            }
            return null;
        }
        if (value instanceof Collection) {
            ArrayList<Object> modifiedList = new ArrayList<Object>(((List)value).size());
            for (Object element : (List)value) {
                modifiedList.add(ProtoUtils.unwrapEnums(element, beanContainer));
            }
            return modifiedList;
        }
        return value;
    }

    public static String toCamelCase(String name) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
    }
}

