/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.protobuf.propertydescriptor;

import com.github.dozermapper.protobuf.builder.ProtoBeanBuilder;
import com.github.dozermapper.protobuf.util.ProtoUtils;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.lang.reflect.Method;
import java.util.Map;
import org.dozer.BeanBuilder;
import org.dozer.MappingException;
import org.dozer.config.BeanContainer;
import org.dozer.factory.DestBeanCreator;
import org.dozer.fieldmap.FieldMap;
import org.dozer.fieldmap.HintContainer;
import org.dozer.propertydescriptor.AbstractPropertyDescriptor;
import org.dozer.propertydescriptor.PropertyDescriptorFactory;
import org.dozer.util.DeepHierarchyUtils;
import org.dozer.util.MappingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoFieldPropertyDescriptor
extends AbstractPropertyDescriptor {
    private final Logger logger = LoggerFactory.getLogger(ProtoFieldPropertyDescriptor.class);
    private final BeanContainer beanContainer;
    private final DestBeanCreator destBeanCreator;
    private final PropertyDescriptorFactory propertyDescriptorFactory;
    private Class<?> _propertyType;
    private Class<?> _genericType;
    private Descriptors.FieldDescriptor _fieldDescriptor;

    public ProtoFieldPropertyDescriptor(Class<?> clazz, String fieldName, boolean isIndexed, int index, HintContainer srcDeepIndexHintContainer, HintContainer destDeepIndexHintContainer, BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        super(clazz, fieldName, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer);
        this.beanContainer = beanContainer;
        this.destBeanCreator = destBeanCreator;
        this.propertyDescriptorFactory = propertyDescriptorFactory;
    }

    public Class<?> getPropertyType() {
        if (this._propertyType == null) {
            Class result;
            if (MappingUtils.isDeepMapping((String)this.fieldName)) {
                try {
                    result = DeepHierarchyUtils.getDeepFieldType((Class)this.clazz, (String)this.fieldName, (HintContainer)this.srcDeepIndexHintContainer, (BeanContainer)this.beanContainer, (DestBeanCreator)this.destBeanCreator, (PropertyDescriptorFactory)this.propertyDescriptorFactory);
                }
                catch (Exception ignore) {
                    this.logger.info("Determine field type by srcDeepIndexHintContainer failed");
                    try {
                        result = DeepHierarchyUtils.getDeepFieldType((Class)this.clazz, (String)this.fieldName, (HintContainer)this.destDeepIndexHintContainer, (BeanContainer)this.beanContainer, (DestBeanCreator)this.destBeanCreator, (PropertyDescriptorFactory)this.propertyDescriptorFactory);
                    }
                    catch (Exception secondIgnore) {
                        this.logger.info("Determine field type by destDeepIndexHintContainer failed");
                        result = null;
                    }
                }
            } else {
                result = ProtoUtils.getJavaClass(this.getFieldDescriptor(), this.beanContainer);
            }
            this._propertyType = result;
        }
        return this._propertyType;
    }

    public Object getPropertyValue(Object bean) {
        Object result;
        if (MappingUtils.isDeepMapping((String)this.fieldName)) {
            result = DeepHierarchyUtils.getDeepFieldValue((Object)bean, (String)this.fieldName, (boolean)this.isIndexed, (int)this.index, (HintContainer)this.srcDeepIndexHintContainer, (BeanContainer)this.beanContainer, (DestBeanCreator)this.destBeanCreator, (PropertyDescriptorFactory)this.propertyDescriptorFactory);
        } else {
            result = this.getSimplePropertyValue(bean);
            if (this.isIndexed) {
                result = MappingUtils.getIndexedValue((Object)result, (int)this.index);
            }
        }
        return result;
    }

    private Object getSimplePropertyValue(Object bean) {
        if (bean instanceof BeanBuilder) {
            return null;
        }
        if (!(bean instanceof Message)) {
            MappingUtils.throwMappingException((String)"Try to pass non proto object to ProtoFieldPropertyDescriptor");
        }
        Object value = ProtoUtils.getFieldValue(bean, this.fieldName);
        return ProtoUtils.unwrapEnums(value, this.beanContainer);
    }

    public void setPropertyValue(Object bean, Object value, FieldMap fieldMap) {
        if (!(bean instanceof ProtoBeanBuilder)) {
            MappingUtils.throwMappingException((String)"should be a ProtoBeanBuilder instance");
        }
        ProtoBeanBuilder builder = (ProtoBeanBuilder)bean;
        if ((value = ProtoUtils.wrapEnums(value)) != null) {
            if (this.getFieldDescriptor().isMapField()) {
                String propertyName = Character.toUpperCase(this.fieldName.charAt(0)) + this.fieldName.substring(1);
                String methodName = String.format("putAll%s", propertyName);
                try {
                    Method mapSetterMethod = builder.internalProtoBuilder().getClass().getMethod(methodName, Map.class);
                    mapSetterMethod.invoke((Object)builder.internalProtoBuilder(), value);
                }
                catch (Exception e) {
                    throw new MappingException("Could not call map setter method " + methodName, (Throwable)e);
                }
            } else {
                builder.internalProtoBuilder().setField(this.getFieldDescriptor(), value);
            }
        } else {
            builder.internalProtoBuilder().clearField(this.getFieldDescriptor());
        }
    }

    public Class<?> genericType() {
        if (this._genericType == null) {
            Class result;
            if (MappingUtils.isDeepMapping((String)this.fieldName)) {
                try {
                    result = DeepHierarchyUtils.getDeepGenericType((Class)this.clazz, (String)this.fieldName, (HintContainer)this.srcDeepIndexHintContainer, (BeanContainer)this.beanContainer, (DestBeanCreator)this.destBeanCreator, (PropertyDescriptorFactory)this.propertyDescriptorFactory);
                }
                catch (Exception ignore) {
                    this.logger.info("Determine field generic type by srcDeepIndexHintContainer failed");
                    try {
                        result = DeepHierarchyUtils.getDeepGenericType((Class)this.clazz, (String)this.fieldName, (HintContainer)this.destDeepIndexHintContainer, (BeanContainer)this.beanContainer, (DestBeanCreator)this.destBeanCreator, (PropertyDescriptorFactory)this.propertyDescriptorFactory);
                    }
                    catch (Exception secondIgnore) {
                        this.logger.info("Determine field generic type by destDeepIndexHintContainer failed");
                        result = null;
                    }
                }
            } else {
                result = ProtoUtils.getJavaGenericClassForCollection(this.getFieldDescriptor(), this.beanContainer);
            }
            this._genericType = result;
        }
        return this._genericType;
    }

    private Descriptors.FieldDescriptor getFieldDescriptor() {
        if (this._fieldDescriptor == null) {
            this._fieldDescriptor = ProtoUtils.getFieldDescriptor(this.clazz, this.fieldName);
            if (this._fieldDescriptor == null && !MappingUtils.isDeepMapping((String)this.fieldName)) {
                MappingUtils.throwMappingException((String)("No field descriptor for field with name: " + this.fieldName));
            }
        }
        return this._fieldDescriptor;
    }
}

