/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.config.processors;

import com.github.dozermapper.core.config.Settings;
import com.github.dozermapper.core.config.SettingsDefaults;
import com.github.dozermapper.core.config.processors.SettingsProcessor;
import com.github.dozermapper.core.config.resolvers.LegacyPropertiesSettingsResolver;
import com.github.dozermapper.core.config.resolvers.SettingsResolver;
import com.github.dozermapper.core.config.resolvers.SystemEnvironmentSettingsResolver;
import com.github.dozermapper.core.config.resolvers.SystemPropertySettingsResolver;
import com.github.dozermapper.core.util.DozerClassLoader;
import com.github.dozermapper.core.util.MappingUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultSettingsProcessor
implements SettingsProcessor {
    private final DozerClassLoader classLoader;
    private List<SettingsResolver> resolvers = new ArrayList<SettingsResolver>();

    public DefaultSettingsProcessor(DozerClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Settings process() {
        this.createSettingsResolvers();
        this.checkForDeprecatedKeys();
        String classLoaderBeanName = String.valueOf(this.getValue("dozer.beans.class-loader-bean", "com.github.dozermapper.core.util.DefaultClassLoader"));
        String proxyResolverBeanName = String.valueOf(this.getValue("dozer.beans.proxy-resolver-bean", "com.github.dozermapper.core.util.DefaultProxyResolver"));
        Integer converterByDestTypeCacheMaxSize = Integer.valueOf(this.getValue("dozer.cache.converter-by-dest-type-maxsize", SettingsDefaults.CONVERTER_BY_DEST_TYPE_CACHE_MAX_SIZE).toString());
        Integer superTypesCacheMaxSize = Integer.valueOf(this.getValue("dozer.cache.super-type-maxsize", SettingsDefaults.SUPER_TYPE_CHECK_CACHE_MAX_SIZE).toString());
        Boolean useJaxbMappingEngine = Boolean.valueOf(this.getValue("dozer.xml.use-jaxb-mapping-engine", SettingsDefaults.USE_JAXB_MAPPING_ENGINE).toString());
        return new Settings(converterByDestTypeCacheMaxSize, superTypesCacheMaxSize, classLoaderBeanName, proxyResolverBeanName, useJaxbMappingEngine);
    }

    private void createSettingsResolvers() {
        String fileName = System.getProperty("dozer.configuration");
        this.resolvers.add(new LegacyPropertiesSettingsResolver(this.classLoader, this.getConfigFileName(fileName, "dozer.properties")));
        this.resolvers.add(new SystemPropertySettingsResolver());
        this.resolvers.add(new SystemEnvironmentSettingsResolver());
        for (SettingsResolver current : this.resolvers) {
            current.init();
        }
    }

    private String getConfigFileName(String fileName, String defaultValue) {
        if (MappingUtils.isBlankOrNull(fileName)) {
            fileName = defaultValue;
        }
        return fileName;
    }

    private void checkForDeprecatedKeys() {
        for (SettingsResolver current : this.resolvers) {
            if (current.get("dozer.el.enabled", null) != null) {
                throw new IllegalArgumentException("Found key in properties for dozer.el.enabled via " + current.getClass().getName() + ". This is deprecated, please use: DozerBeanMapperBuilder.withELEngine()");
            }
            if (current.get("com.github.dozermapper.core.util.DozerClassLoader", null) != null) {
                throw new IllegalArgumentException("Found key in properties for com.github.dozermapper.core.util.DozerClassLoader via " + current.getClass().getName() + ". This is deprecated, please use: " + "dozer.beans.class-loader-bean");
            }
            if (current.get("com.github.dozermapper.core.util.DozerProxyResolver", null) != null) {
                throw new IllegalArgumentException("Found key in properties for com.github.dozermapper.core.util.DozerProxyResolver via " + current.getClass().getName() + ". This is deprecated, please use: " + "dozer.beans.proxy-resolver-bean");
            }
            if (current.get("dozer.cache.converter.by.dest.type.maxsize", null) != null) {
                throw new IllegalArgumentException("Found key in properties for dozer.cache.converter.by.dest.type.maxsize via " + current.getClass().getName() + ". This is deprecated, please use: " + "dozer.cache.converter-by-dest-type-maxsize");
            }
            if (current.get("dozer.cache.super.type.maxsize", null) == null) continue;
            throw new IllegalArgumentException("Found key in properties for dozer.cache.super.type.maxsize via " + current.getClass().getName() + ". This is deprecated, please use: " + "dozer.cache.super-type-maxsize");
        }
    }

    private Object getValue(String key, Object defaultValue) {
        SettingsResolver current;
        Object answer = null;
        Iterator<SettingsResolver> iterator = this.resolvers.iterator();
        while (iterator.hasNext() && (answer = (current = iterator.next()).get(key, null)) == null) {
        }
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }
}

