/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.converters;

import java.lang.reflect.Constructor;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.beanutils.Converter;
import org.dozer.converters.ConversionException;

public class DateConverter
implements Converter {
    private DateFormat dateFormat;

    public DateConverter(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Object convert(Class destClass, Object srcObj) {
        long time;
        Class<?> srcFieldClass = srcObj.getClass();
        int nanos = 0;
        if (Calendar.class.isAssignableFrom(srcFieldClass)) {
            Calendar inVal = (Calendar)srcObj;
            time = inVal.getTime().getTime();
        } else if (Timestamp.class.isAssignableFrom(srcFieldClass)) {
            Timestamp timestamp = (Timestamp)srcObj;
            time = timestamp.getTime();
            nanos = timestamp.getNanos();
        } else if (Date.class.isAssignableFrom(srcFieldClass)) {
            time = ((Date)srcObj).getTime();
        } else if (XMLGregorianCalendar.class.isAssignableFrom(srcFieldClass)) {
            time = ((XMLGregorianCalendar)srcObj).toGregorianCalendar().getTimeInMillis();
        } else {
            if (this.dateFormat != null && String.class.isAssignableFrom(srcObj.getClass())) {
                try {
                    if ("".equals(srcObj)) {
                        return null;
                    }
                    time = this.dateFormat.parse((String)srcObj).getTime();
                }
                catch (ParseException e) {
                    throw new ConversionException("Unable to parse source object using specified date format", e);
                }
            }
            try {
                time = Long.parseLong(srcObj.toString());
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Unable to determine time in millis of source object", e);
            }
        }
        try {
            Constructor constructor;
            if (Calendar.class.isAssignableFrom(destClass)) {
                constructor = destClass.getConstructor(new Class[0]);
                Calendar result = (Calendar)constructor.newInstance(new Object[0]);
                result.setTimeInMillis(time);
                return result;
            }
            if (this.dateFormat != null && String.class.isAssignableFrom(destClass)) {
                return this.dateFormat.format(new Date(time));
            }
            constructor = destClass.getConstructor(Long.TYPE);
            Object result = constructor.newInstance(time);
            if (nanos != 0 && Timestamp.class.isAssignableFrom(destClass)) {
                ((Timestamp)result).setNanos(nanos);
            }
            return result;
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }
}

