/*
 * Decompiled with CFR 0.152.
 */
package com.doublesymmetry.kotlinaudio.players;

import android.content.Context;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.ResultReceiver;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.RatingCompat;
import android.support.v4.media.session.MediaSessionCompat;
import androidx.annotation.CallSuper;
import androidx.core.content.ContextCompat;
import androidx.media.AudioAttributesCompat;
import androidx.media.AudioFocusRequestCompat;
import androidx.media.AudioManagerCompat;
import com.doublesymmetry.kotlinaudio.event.EventHolder;
import com.doublesymmetry.kotlinaudio.event.NotificationEventHolder;
import com.doublesymmetry.kotlinaudio.event.PlayerEventHolder;
import com.doublesymmetry.kotlinaudio.models.AudioContentType;
import com.doublesymmetry.kotlinaudio.models.AudioItem;
import com.doublesymmetry.kotlinaudio.models.AudioItemHolder;
import com.doublesymmetry.kotlinaudio.models.AudioItemTransitionReason;
import com.doublesymmetry.kotlinaudio.models.AudioPlayerState;
import com.doublesymmetry.kotlinaudio.models.BufferConfig;
import com.doublesymmetry.kotlinaudio.models.CacheConfig;
import com.doublesymmetry.kotlinaudio.models.DefaultPlayerOptions;
import com.doublesymmetry.kotlinaudio.models.MediaSessionCallback;
import com.doublesymmetry.kotlinaudio.models.MediaType;
import com.doublesymmetry.kotlinaudio.models.PlayWhenReadyChangeData;
import com.doublesymmetry.kotlinaudio.models.PlaybackError;
import com.doublesymmetry.kotlinaudio.models.PlayerConfig;
import com.doublesymmetry.kotlinaudio.models.PlayerOptions;
import com.doublesymmetry.kotlinaudio.models.PositionChangedReason;
import com.doublesymmetry.kotlinaudio.notification.NotificationManager;
import com.doublesymmetry.kotlinaudio.players.components.MediaItemExtKt;
import com.doublesymmetry.kotlinaudio.players.components.PlayerCache;
import com.doublesymmetry.kotlinaudio.utils.UtilsKt;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ForwardingPlayer;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.MediaMetadata;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.ext.mediasession.MediaSessionConnector;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.source.dash.DashChunkSource;
import com.google.android.exoplayer2.source.dash.DashMediaSource;
import com.google.android.exoplayer2.source.dash.DefaultDashChunkSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.source.smoothstreaming.DefaultSsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsMediaSource;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer2.upstream.RawResourceDataSource;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSource;
import com.google.android.exoplayer2.upstream.cache.SimpleCache;
import com.google.android.exoplayer2.util.Util;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 \u008e\u00012\u00020\u0001:\u0004\u008e\u0001\u008f\u0001B+\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010f\u001a\u00020gH\u0002J\b\u0010h\u001a\u00020gH\u0017J\u001a\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020l2\b\u0010m\u001a\u0004\u0018\u00010nH\u0002J\b\u0010o\u001a\u00020pH\u0002J\u001a\u0010q\u001a\u00020j2\u0006\u0010k\u001a\u00020l2\b\u0010m\u001a\u0004\u0018\u00010nH\u0002J\u0018\u0010r\u001a\u00020s2\u0006\u0010k\u001a\u00020l2\u0006\u0010m\u001a\u00020nH\u0002J\u001a\u0010t\u001a\u00020j2\u0006\u0010k\u001a\u00020l2\b\u0010m\u001a\u0004\u0018\u00010nH\u0002J\b\u0010u\u001a\u00020gH\u0017J\u0010\u0010v\u001a\u00020n2\u0006\u0010m\u001a\u00020nH\u0002J\u0010\u0010w\u001a\u00020j2\u0006\u0010x\u001a\u00020\u001aH\u0004J\u0010\u0010y\u001a\u00020g2\u0006\u0010z\u001a\u00020\u001aH\u0016J\u001a\u0010y\u001a\u00020g2\u0006\u0010z\u001a\u00020\u001a2\b\b\u0002\u00108\u001a\u00020\fH\u0016J\u0010\u0010{\u001a\u00020g2\u0006\u0010|\u001a\u00020UH\u0016J\u0006\u0010}\u001a\u00020gJ\u0006\u0010~\u001a\u00020gJ\u0006\u0010\u007f\u001a\u00020gJ\t\u0010\u0080\u0001\u001a\u00020gH\u0002J\u001b\u0010\u0081\u0001\u001a\u00020g2\u0006\u0010\u001d\u001a\u00020\u00122\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0016J\u001c\u0010\u0084\u0001\u001a\u00020g2\u0007\u0010\u0085\u0001\u001a\u00020\u00122\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0016J\u000f\u0010\u0086\u0001\u001a\u00020g2\u0006\u0010}\u001a\u00020\fJ\u0012\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\t\u0010\u0089\u0001\u001a\u00020gH\u0017J\u0007\u0010\u008a\u0001\u001a\u00020gJ\u001c\u0010\u008b\u0001\u001a\u00020g2\u000b\b\u0002\u0010\u008c\u0001\u001a\u0004\u0018\u00010\u001aH\u0000\u00a2\u0006\u0003\b\u008d\u0001R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0014R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010*\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000eR\u0011\u0010+\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u000eR\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00108\u001a\u00020\f2\u0006\u00107\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010\u000e\"\u0004\b:\u0010\u0010R\u001c\u0010;\u001a\u0004\u0018\u00010<X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R$\u0010B\u001a\u00020A2\u0006\u00107\u001a\u00020A8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010I\u001a\u00020JX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR$\u0010N\u001a\u00020M2\u0006\u00107\u001a\u00020M@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u0011\u0010S\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\bT\u0010\u0014R$\u0010V\u001a\u00020U2\u0006\u00107\u001a\u00020U@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010X\"\u0004\bY\u0010ZR\u000e\u0010[\u001a\u00020\\X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010]\u001a\u00020\f2\u0006\u00107\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b^\u0010\u000e\"\u0004\b_\u0010\u0010R$\u0010`\u001a\u00020A2\u0006\u00107\u001a\u00020A8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\ba\u0010D\"\u0004\bb\u0010FR\u001e\u0010c\u001a\u00020A2\u0006\u00107\u001a\u00020A@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\bd\u0010FR\u000e\u0010e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0090\u0001"}, d2={"Lcom/doublesymmetry/kotlinaudio/players/BaseAudioPlayer;", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "context", "Landroid/content/Context;", "playerConfig", "Lcom/doublesymmetry/kotlinaudio/models/PlayerConfig;", "bufferConfig", "Lcom/doublesymmetry/kotlinaudio/models/BufferConfig;", "cacheConfig", "Lcom/doublesymmetry/kotlinaudio/models/CacheConfig;", "(Landroid/content/Context;Lcom/doublesymmetry/kotlinaudio/models/PlayerConfig;Lcom/doublesymmetry/kotlinaudio/models/BufferConfig;Lcom/doublesymmetry/kotlinaudio/models/CacheConfig;)V", "automaticallyUpdateNotificationMetadata", "", "getAutomaticallyUpdateNotificationMetadata", "()Z", "setAutomaticallyUpdateNotificationMetadata", "(Z)V", "bufferedPosition", "", "getBufferedPosition", "()J", "cache", "Lcom/google/android/exoplayer2/upstream/cache/SimpleCache;", "getContext$kotlin_audio_release", "()Landroid/content/Context;", "currentItem", "Lcom/doublesymmetry/kotlinaudio/models/AudioItem;", "getCurrentItem", "()Lcom/doublesymmetry/kotlinaudio/models/AudioItem;", "duration", "getDuration", "event", "Lcom/doublesymmetry/kotlinaudio/event/EventHolder;", "getEvent", "()Lcom/doublesymmetry/kotlinaudio/event/EventHolder;", "exoPlayer", "Lcom/google/android/exoplayer2/ExoPlayer;", "getExoPlayer", "()Lcom/google/android/exoplayer2/ExoPlayer;", "focus", "Landroidx/media/AudioFocusRequestCompat;", "hasAudioFocus", "isCurrentMediaItemLive", "isPlaying", "mediaSession", "Landroid/support/v4/media/session/MediaSessionCompat;", "mediaSessionConnector", "Lcom/google/android/exoplayer2/ext/mediasession/MediaSessionConnector;", "notificationEventHolder", "Lcom/doublesymmetry/kotlinaudio/event/NotificationEventHolder;", "notificationManager", "Lcom/doublesymmetry/kotlinaudio/notification/NotificationManager;", "getNotificationManager", "()Lcom/doublesymmetry/kotlinaudio/notification/NotificationManager;", "oldPosition", "value", "playWhenReady", "getPlayWhenReady", "setPlayWhenReady", "playbackError", "Lcom/doublesymmetry/kotlinaudio/models/PlaybackError;", "getPlaybackError", "()Lcom/doublesymmetry/kotlinaudio/models/PlaybackError;", "setPlaybackError", "(Lcom/doublesymmetry/kotlinaudio/models/PlaybackError;)V", "", "playbackSpeed", "getPlaybackSpeed", "()F", "setPlaybackSpeed", "(F)V", "playerEventHolder", "Lcom/doublesymmetry/kotlinaudio/event/PlayerEventHolder;", "playerOptions", "Lcom/doublesymmetry/kotlinaudio/models/PlayerOptions;", "getPlayerOptions", "()Lcom/doublesymmetry/kotlinaudio/models/PlayerOptions;", "Lcom/doublesymmetry/kotlinaudio/models/AudioPlayerState;", "playerState", "getPlayerState", "()Lcom/doublesymmetry/kotlinaudio/models/AudioPlayerState;", "setPlayerState", "(Lcom/doublesymmetry/kotlinaudio/models/AudioPlayerState;)V", "position", "getPosition", "", "ratingType", "getRatingType", "()I", "setRatingType", "(I)V", "scope", "Lkotlinx/coroutines/CoroutineScope;", "skipSilence", "getSkipSilence", "setSkipSilence", "volume", "getVolume", "setVolume", "volumeMultiplier", "setVolumeMultiplier", "wasDucking", "abandonAudioFocusIfHeld", "", "clear", "createDashSource", "Lcom/google/android/exoplayer2/source/MediaSource;", "mediaItem", "Lcom/google/android/exoplayer2/MediaItem;", "factory", "Lcom/google/android/exoplayer2/upstream/DataSource$Factory;", "createForwardingPlayer", "Lcom/google/android/exoplayer2/ForwardingPlayer;", "createHlsSource", "createProgressiveSource", "Lcom/google/android/exoplayer2/source/ProgressiveMediaSource;", "createSsSource", "destroy", "enableCaching", "getMediaSourceFromAudioItem", "audioItem", "load", "item", "onAudioFocusChange", "focusChange", "pause", "play", "prepare", "requestAudioFocus", "seek", "unit", "Ljava/util/concurrent/TimeUnit;", "seekBy", "offset", "setPauseAtEndOfItem", "setupBuffer", "Lcom/google/android/exoplayer2/DefaultLoadControl;", "stop", "togglePlaying", "updateNotificationIfNecessary", "overrideAudioItem", "updateNotificationIfNecessary$kotlin_audio_release", "Companion", "PlayerListener", "kotlin-audio_release"})
public abstract class BaseAudioPlayer
implements AudioManager.OnAudioFocusChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @Nullable
    private final BufferConfig bufferConfig;
    @Nullable
    private final CacheConfig cacheConfig;
    @NotNull
    private final ExoPlayer exoPlayer;
    @Nullable
    private SimpleCache cache;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private PlayerConfig playerConfig;
    @NotNull
    private final NotificationManager notificationManager;
    @NotNull
    private final PlayerOptions playerOptions;
    @Nullable
    private PlaybackError playbackError;
    @NotNull
    private AudioPlayerState playerState;
    private long oldPosition;
    private boolean automaticallyUpdateNotificationMetadata;
    private float volumeMultiplier;
    @NotNull
    private final NotificationEventHolder notificationEventHolder;
    @NotNull
    private final PlayerEventHolder playerEventHolder;
    private int ratingType;
    @NotNull
    private final EventHolder event;
    @Nullable
    private AudioFocusRequestCompat focus;
    private boolean hasAudioFocus;
    private boolean wasDucking;
    @NotNull
    private final MediaSessionCompat mediaSession;
    @NotNull
    private final MediaSessionConnector mediaSessionConnector;
    @NotNull
    public static final String APPLICATION_NAME = "react-native-track-player";

    /*
     * WARNING - void declaration
     */
    public BaseAudioPlayer(@NotNull Context context, @NotNull PlayerConfig playerConfig, @Nullable BufferConfig bufferConfig, @Nullable CacheConfig cacheConfig) {
        ExoPlayer.Builder builder;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)playerConfig, (String)"playerConfig");
        this.context = context;
        this.bufferConfig = bufferConfig;
        this.cacheConfig = cacheConfig;
        this.scope = CoroutineScopeKt.MainScope();
        this.playerConfig = playerConfig;
        this.playerOptions = new DefaultPlayerOptions(false, 1, null);
        this.playerState = AudioPlayerState.IDLE;
        this.automaticallyUpdateNotificationMetadata = true;
        this.volumeMultiplier = 1.0f;
        this.notificationEventHolder = new NotificationEventHolder();
        this.playerEventHolder = new PlayerEventHolder();
        this.event = new EventHolder(this.notificationEventHolder, this.playerEventHolder);
        this.mediaSession = new MediaSessionCompat(this.context, "KotlinAudioPlayer");
        this.mediaSessionConnector = new MediaSessionConnector(this.mediaSession);
        if (this.cacheConfig != null) {
            this.cache = PlayerCache.INSTANCE.getInstance(this.context, this.cacheConfig);
        }
        ExoPlayer.Builder builder2 = builder = new ExoPlayer.Builder(this.context).setHandleAudioBecomingNoisy(playerConfig.getHandleAudioBecomingNoisy());
        BaseAudioPlayer baseAudioPlayer = this;
        boolean bl = false;
        if (this.bufferConfig != null) {
            void $this$_init__u24lambda_u2d0;
            $this$_init__u24lambda_u2d0.setLoadControl((LoadControl)this.setupBuffer(this.bufferConfig));
        }
        ExoPlayer exoPlayer = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)exoPlayer, (String)"Builder(context)\n       \u2026   }\n            .build()");
        baseAudioPlayer.exoPlayer = exoPlayer;
        this.mediaSession.setActive(true);
        Player playerToUse = playerConfig.getInterceptPlayerActionsTriggeredExternally() ? (Player)this.createForwardingPlayer() : (Player)this.exoPlayer;
        this.notificationManager = new NotificationManager(this.context, playerToUse, this.mediaSession, this.mediaSessionConnector, this.notificationEventHolder, this.playerEventHolder);
        this.exoPlayer.addListener((Player.Listener)new PlayerListener());
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(playerConfig, this, playerToUse, null){
            int label;
            final /* synthetic */ PlayerConfig $playerConfig;
            final /* synthetic */ BaseAudioPlayer this$0;
            final /* synthetic */ Player $playerToUse;
            {
                this.$playerConfig = $playerConfig;
                this.this$0 = $receiver;
                this.$playerToUse = $playerToUse;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        int n;
                        ResultKt.throwOnFailure((Object)object);
                        AudioAttributes.Builder builder = new AudioAttributes.Builder().setUsage(1);
                        switch (WhenMappings.$EnumSwitchMapping$0[this.$playerConfig.getAudioContentType().ordinal()]) {
                            case 1: {
                                n = 2;
                                break;
                            }
                            case 2: {
                                n = 1;
                                break;
                            }
                            case 3: {
                                n = 4;
                                break;
                            }
                            case 4: {
                                n = 3;
                                break;
                            }
                            case 5: {
                                n = 0;
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        AudioAttributes audioAttributes = builder.setContentType(n).build();
                        Intrinsics.checkNotNullExpressionValue((Object)audioAttributes, (String)"Builder()\n              \u2026\n                .build()");
                        AudioAttributes audioAttributes2 = audioAttributes;
                        this.this$0.getExoPlayer().setAudioAttributes(audioAttributes2, this.$playerConfig.getHandleAudioFocus());
                        this.this$0.mediaSessionConnector.setPlayer(this.$playerToUse);
                        this.this$0.mediaSessionConnector.setMediaMetadataProvider(arg_0 -> 2.invokeSuspend$lambda-0(this.this$0, arg_0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final MediaMetadataCompat invokeSuspend$lambda-0(BaseAudioPlayer this$0, Player it) {
                return this$0.getNotificationManager().getMediaMetadataCompat();
            }

            @Metadata(mv={1, 7, 1}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[AudioContentType.values().length];
                    nArray[AudioContentType.MUSIC.ordinal()] = 1;
                    nArray[AudioContentType.SPEECH.ordinal()] = 2;
                    nArray[AudioContentType.SONIFICATION.ordinal()] = 3;
                    nArray[AudioContentType.MOVIE.ordinal()] = 4;
                    nArray[AudioContentType.UNKNOWN.ordinal()] = 5;
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }), (int)3, null);
        this.playerEventHolder.updateAudioPlayerState$kotlin_audio_release(AudioPlayerState.IDLE);
    }

    @NotNull
    public final Context getContext$kotlin_audio_release() {
        return this.context;
    }

    @NotNull
    protected final ExoPlayer getExoPlayer() {
        return this.exoPlayer;
    }

    @NotNull
    public final NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    @NotNull
    public PlayerOptions getPlayerOptions() {
        return this.playerOptions;
    }

    @Nullable
    public AudioItem getCurrentItem() {
        Object object = this.exoPlayer.getCurrentMediaItem();
        return object != null && (object = MediaItemExtKt.getAudioItemHolder((MediaItem)object)) != null ? ((AudioItemHolder)object).getAudioItem() : null;
    }

    @Nullable
    public final PlaybackError getPlaybackError() {
        return this.playbackError;
    }

    public final void setPlaybackError(@Nullable PlaybackError playbackError) {
        this.playbackError = playbackError;
    }

    @NotNull
    public final AudioPlayerState getPlayerState() {
        return this.playerState;
    }

    private final void setPlayerState(AudioPlayerState value) {
        if (value != this.playerState) {
            this.playerState = value;
            this.playerEventHolder.updateAudioPlayerState$kotlin_audio_release(value);
            if (!this.playerConfig.getHandleAudioFocus()) {
                switch (WhenMappings.$EnumSwitchMapping$0[value.ordinal()]) {
                    case 1: 
                    case 2: {
                        this.abandonAudioFocusIfHeld();
                        break;
                    }
                    case 3: {
                        this.requestAudioFocus();
                    }
                }
            }
        }
    }

    public final boolean getPlayWhenReady() {
        return this.exoPlayer.getPlayWhenReady();
    }

    public final void setPlayWhenReady(boolean value) {
        this.exoPlayer.setPlayWhenReady(value);
    }

    public final long getDuration() {
        return this.exoPlayer.getDuration() == -9223372036854775807L ? 0L : this.exoPlayer.getDuration();
    }

    public final boolean isCurrentMediaItemLive() {
        return this.exoPlayer.isCurrentMediaItemLive();
    }

    public final long getPosition() {
        return this.exoPlayer.getCurrentPosition() == -1L ? 0L : this.exoPlayer.getCurrentPosition();
    }

    public final long getBufferedPosition() {
        return this.exoPlayer.getBufferedPosition() == -1L ? 0L : this.exoPlayer.getBufferedPosition();
    }

    public final float getVolume() {
        return this.exoPlayer.getVolume();
    }

    public final void setVolume(float value) {
        this.exoPlayer.setVolume(value * this.volumeMultiplier);
    }

    public final float getPlaybackSpeed() {
        return this.exoPlayer.getPlaybackParameters().speed;
    }

    public final void setPlaybackSpeed(float value) {
        this.exoPlayer.setPlaybackSpeed(value);
    }

    public final boolean getAutomaticallyUpdateNotificationMetadata() {
        return this.automaticallyUpdateNotificationMetadata;
    }

    public final void setAutomaticallyUpdateNotificationMetadata(boolean bl) {
        this.automaticallyUpdateNotificationMetadata = bl;
    }

    private final void setVolumeMultiplier(float value) {
        this.volumeMultiplier = value;
        this.setVolume(this.getVolume());
    }

    public final boolean isPlaying() {
        return this.exoPlayer.isPlaying();
    }

    public final int getRatingType() {
        return this.ratingType;
    }

    public final void setRatingType(int value) {
        this.ratingType = value;
        this.mediaSession.setRatingType(this.ratingType);
        this.mediaSessionConnector.setRatingCallback(new MediaSessionConnector.RatingCallback(this){
            final /* synthetic */ BaseAudioPlayer this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onCommand(@NotNull Player player, @NotNull String command, @Nullable Bundle extras, @Nullable ResultReceiver cb) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                return true;
            }

            public void onSetRating(@NotNull Player player, @NotNull RatingCompat rating) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)rating, (String)"rating");
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(new MediaSessionCallback.RATING(rating, null));
            }

            public void onSetRating(@NotNull Player player, @NotNull RatingCompat rating, @Nullable Bundle extras) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)rating, (String)"rating");
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(new MediaSessionCallback.RATING(rating, extras));
            }
        });
    }

    @NotNull
    public final EventHolder getEvent() {
        return this.event;
    }

    private final ForwardingPlayer createForwardingPlayer() {
        ExoPlayer exoPlayer = this.exoPlayer;
        return new ForwardingPlayer(this, exoPlayer){
            final /* synthetic */ BaseAudioPlayer this$0;
            {
                this.this$0 = $receiver;
                super((Player)$super_call_param$1);
            }

            public void play() {
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(MediaSessionCallback.PLAY.INSTANCE);
            }

            public void pause() {
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(MediaSessionCallback.PAUSE.INSTANCE);
            }

            public void seekToNext() {
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(MediaSessionCallback.NEXT.INSTANCE);
            }

            public void seekToPrevious() {
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(MediaSessionCallback.PREVIOUS.INSTANCE);
            }

            public void seekForward() {
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(MediaSessionCallback.FORWARD.INSTANCE);
            }

            public void seekBack() {
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(MediaSessionCallback.REWIND.INSTANCE);
            }

            public void stop() {
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(MediaSessionCallback.STOP.INSTANCE);
            }

            public void seekTo(int mediaItemIndex, long positionMs) {
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(new MediaSessionCallback.SEEK(positionMs));
            }

            public void seekTo(long positionMs) {
                BaseAudioPlayer.access$getPlayerEventHolder$p(this.this$0).updateOnPlayerActionTriggeredExternally$kotlin_audio_release(new MediaSessionCallback.SEEK(positionMs));
            }
        };
    }

    public final void updateNotificationIfNecessary$kotlin_audio_release(@Nullable AudioItem overrideAudioItem) {
        if (this.automaticallyUpdateNotificationMetadata) {
            this.notificationManager.setOverrideAudioItem$kotlin_audio_release(overrideAudioItem);
        }
    }

    public static /* synthetic */ void updateNotificationIfNecessary$kotlin_audio_release$default(BaseAudioPlayer baseAudioPlayer, AudioItem audioItem, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateNotificationIfNecessary");
        }
        if ((n & 1) != 0) {
            audioItem = null;
        }
        baseAudioPlayer.updateNotificationIfNecessary$kotlin_audio_release(audioItem);
    }

    /*
     * Unable to fully structure code
     */
    private final DefaultLoadControl setupBuffer(BufferConfig bufferConfig) {
        $this$setupBuffer_u24lambda_u2d1 = bufferConfig;
        $i$a$-apply-BaseAudioPlayer$setupBuffer$1 = false;
        multiplier = 2;
        if ($this$setupBuffer_u24lambda_u2d1.getMinBuffer() == null) ** GOTO lbl-1000
        v0 = $this$setupBuffer_u24lambda_u2d1.getMinBuffer();
        if (v0 == null || v0 != 0) {
            v1 = $this$setupBuffer_u24lambda_u2d1.getMinBuffer();
        } else lbl-1000:
        // 2 sources

        {
            v1 = minBuffer = 50000;
        }
        if ($this$setupBuffer_u24lambda_u2d1.getMaxBuffer() == null) ** GOTO lbl-1000
        v2 = $this$setupBuffer_u24lambda_u2d1.getMaxBuffer();
        if (v2 == null || v2 != 0) {
            v3 = $this$setupBuffer_u24lambda_u2d1.getMaxBuffer();
        } else lbl-1000:
        // 2 sources

        {
            v3 = maxBuffer = 50000;
        }
        if ($this$setupBuffer_u24lambda_u2d1.getPlayBuffer() == null) ** GOTO lbl-1000
        v4 = $this$setupBuffer_u24lambda_u2d1.getPlayBuffer();
        if (v4 == null || v4 != 0) {
            v5 = $this$setupBuffer_u24lambda_u2d1.getPlayBuffer();
        } else lbl-1000:
        // 2 sources

        {
            v5 = playBuffer = 2500;
        }
        if ($this$setupBuffer_u24lambda_u2d1.getBackBuffer() == null) ** GOTO lbl-1000
        v6 = $this$setupBuffer_u24lambda_u2d1.getBackBuffer();
        if (v6 == null || v6 != 0) {
            v7 = $this$setupBuffer_u24lambda_u2d1.getBackBuffer();
        } else lbl-1000:
        // 2 sources

        {
            v7 = 0;
        }
        backBuffer = v7;
        v8 = new DefaultLoadControl.Builder().setBufferDurationsMs(minBuffer, maxBuffer, playBuffer, playBuffer * multiplier).setBackBuffer(backBuffer, false).build();
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"Builder()\n              \u2026\n                .build()");
        return v8;
    }

    public void load(@NotNull AudioItem item, boolean playWhenReady) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.exoPlayer.setPlayWhenReady(playWhenReady);
        this.load(item);
    }

    public static /* synthetic */ void load$default(BaseAudioPlayer baseAudioPlayer, AudioItem audioItem, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: load");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        baseAudioPlayer.load(audioItem, bl);
    }

    public void load(@NotNull AudioItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        MediaSource mediaSource = this.getMediaSourceFromAudioItem(item);
        this.exoPlayer.addMediaSource(mediaSource);
        this.exoPlayer.prepare();
    }

    public final void togglePlaying() {
        if (this.exoPlayer.isPlaying()) {
            this.pause();
        } else {
            this.play();
        }
    }

    public final boolean getSkipSilence() {
        return this.exoPlayer.getSkipSilenceEnabled();
    }

    public final void setSkipSilence(boolean value) {
        this.exoPlayer.setSkipSilenceEnabled(value);
    }

    public final void play() {
        this.exoPlayer.play();
        if (this.getCurrentItem() != null) {
            this.exoPlayer.prepare();
        }
    }

    public final void prepare() {
        if (this.getCurrentItem() != null) {
            this.exoPlayer.prepare();
        }
    }

    public final void pause() {
        this.exoPlayer.pause();
    }

    @CallSuper
    public void stop() {
        this.setPlayerState(AudioPlayerState.STOPPED);
        this.exoPlayer.setPlayWhenReady(false);
        this.exoPlayer.stop();
    }

    @CallSuper
    public void clear() {
        this.exoPlayer.clearMediaItems();
    }

    public final void setPauseAtEndOfItem(boolean pause) {
        this.exoPlayer.setPauseAtEndOfMediaItems(pause);
    }

    @CallSuper
    public void destroy() {
        this.abandonAudioFocusIfHeld();
        this.stop();
        this.notificationManager.destroy$kotlin_audio_release();
        this.exoPlayer.release();
        SimpleCache simpleCache = this.cache;
        if (simpleCache != null) {
            simpleCache.release();
        }
        this.cache = null;
        this.mediaSession.setActive(false);
    }

    public void seek(long duration, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        long positionMs = TimeUnit.MILLISECONDS.convert(duration, unit);
        this.exoPlayer.seekTo(positionMs);
    }

    public void seekBy(long offset, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        long positionMs = this.exoPlayer.getCurrentPosition() + TimeUnit.MILLISECONDS.convert(offset, unit);
        this.exoPlayer.seekTo(positionMs);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected final MediaSource getMediaSourceFromAudioItem(@NotNull AudioItem audioItem) {
        Intrinsics.checkNotNullParameter((Object)audioItem, (String)"audioItem");
        uri = Uri.parse((String)audioItem.getAudioUrl());
        v0 = new MediaItem.Builder().setUri(audioItem.getAudioUrl()).setTag((Object)new AudioItemHolder(audioItem)).build();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"Builder()\n            .s\u2026em))\n            .build()");
        mediaItem = v0;
        if (audioItem.getOptions() == null) ** GOTO lbl-1000
        v1 = audioItem.getOptions();
        Intrinsics.checkNotNull((Object)v1);
        var5_4 = v1.getUserAgent();
        if (var5_4 == null || StringsKt.isBlank((CharSequence)var5_4) != false) lbl-1000:
        // 2 sources

        {
            v2 = Util.getUserAgent((Context)this.context, (String)"react-native-track-player");
        } else {
            v3 = audioItem.getOptions();
            Intrinsics.checkNotNull((Object)v3);
            v2 = v3.getUserAgent();
        }
        userAgent = v2;
        v4 = audioItem.getOptions();
        if ((v4 != null ? v4.getResourceId() : null) != null) {
            raw = new RawResourceDataSource(this.context);
            raw.open(new DataSpec(uri));
            v5 = (DataSource.Factory)LambdaMetafactory.metafactory(null, null, null, ()Lcom/google/android/exoplayer2/upstream/DataSource;, getMediaSourceFromAudioItem$lambda-2(com.google.android.exoplayer2.upstream.RawResourceDataSource ), ()Lcom/google/android/exoplayer2/upstream/DataSource;)((RawResourceDataSource)raw);
        } else if (UtilsKt.isUriLocal(uri)) {
            v5 = (DataSource.Factory)new DefaultDataSourceFactory(this.context, userAgent);
        } else {
            $this$getMediaSourceFromAudioItem_u24lambda_u2d4 = var7_7 = new DefaultHttpDataSource.Factory();
            $i$a$-apply-BaseAudioPlayer$getMediaSourceFromAudioItem$factory$tempFactory$1 = false;
            $this$getMediaSourceFromAudioItem_u24lambda_u2d4.setUserAgent(userAgent);
            $this$getMediaSourceFromAudioItem_u24lambda_u2d4.setAllowCrossProtocolRedirects(true);
            v6 = audioItem.getOptions();
            if (v6 != null && (v6 = v6.getHeaders()) != null) {
                it = v6;
                $i$a$-let-BaseAudioPlayer$getMediaSourceFromAudioItem$factory$tempFactory$1$1 = false;
                $this$getMediaSourceFromAudioItem_u24lambda_u2d4.setDefaultRequestProperties(MapsKt.toMap((Map)it));
            }
            tempFactory = var7_7;
            v5 = this.enableCaching((DataSource.Factory)tempFactory);
        }
        factory = v5;
        switch (WhenMappings.$EnumSwitchMapping$1[audioItem.getType().ordinal()]) {
            case 1: {
                v7 = this.createDashSource(mediaItem, factory);
                break;
            }
            case 2: {
                v7 = this.createHlsSource(mediaItem, factory);
                break;
            }
            case 3: {
                v7 = this.createSsSource(mediaItem, factory);
                break;
            }
            default: {
                v7 = (MediaSource)this.createProgressiveSource(mediaItem, factory);
            }
        }
        return v7;
    }

    private final MediaSource createDashSource(MediaItem mediaItem, DataSource.Factory factory) {
        DataSource.Factory factory2 = factory;
        Intrinsics.checkNotNull((Object)factory2);
        DashMediaSource dashMediaSource = new DashMediaSource.Factory((DashChunkSource.Factory)new DefaultDashChunkSource.Factory(factory2), factory).createMediaSource(mediaItem);
        Intrinsics.checkNotNullExpressionValue((Object)dashMediaSource, (String)"Factory(DefaultDashChunk\u2026ateMediaSource(mediaItem)");
        return (MediaSource)dashMediaSource;
    }

    private final MediaSource createHlsSource(MediaItem mediaItem, DataSource.Factory factory) {
        DataSource.Factory factory2 = factory;
        Intrinsics.checkNotNull((Object)factory2);
        HlsMediaSource hlsMediaSource = new HlsMediaSource.Factory(factory2).createMediaSource(mediaItem);
        Intrinsics.checkNotNullExpressionValue((Object)hlsMediaSource, (String)"Factory(factory!!)\n     \u2026ateMediaSource(mediaItem)");
        return (MediaSource)hlsMediaSource;
    }

    private final MediaSource createSsSource(MediaItem mediaItem, DataSource.Factory factory) {
        DataSource.Factory factory2 = factory;
        Intrinsics.checkNotNull((Object)factory2);
        SsMediaSource ssMediaSource = new SsMediaSource.Factory((SsChunkSource.Factory)new DefaultSsChunkSource.Factory(factory2), factory).createMediaSource(mediaItem);
        Intrinsics.checkNotNullExpressionValue((Object)ssMediaSource, (String)"Factory(DefaultSsChunkSo\u2026ateMediaSource(mediaItem)");
        return (MediaSource)ssMediaSource;
    }

    private final ProgressiveMediaSource createProgressiveSource(MediaItem mediaItem, DataSource.Factory factory) {
        ProgressiveMediaSource progressiveMediaSource = new ProgressiveMediaSource.Factory(factory, (ExtractorsFactory)new DefaultExtractorsFactory().setConstantBitrateSeekingEnabled(true)).createMediaSource(mediaItem);
        Intrinsics.checkNotNullExpressionValue((Object)progressiveMediaSource, (String)"Factory(\n            fac\u2026ateMediaSource(mediaItem)");
        return progressiveMediaSource;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final DataSource.Factory enableCaching(DataSource.Factory factory) {
        DataSource.Factory factory2;
        if (this.cache != null && this.cacheConfig != null) {
            Long l = this.cacheConfig.getMaxCacheSize();
            if ((l != null ? l : 0L) > 0L) {
                CacheDataSource.Factory factory3;
                CacheDataSource.Factory $this$enableCaching_u24lambda_u2d5 = factory3 = new CacheDataSource.Factory();
                boolean bl = false;
                SimpleCache simpleCache = this.cache;
                Intrinsics.checkNotNull((Object)simpleCache);
                $this$enableCaching_u24lambda_u2d5.setCache((Cache)simpleCache);
                $this$enableCaching_u24lambda_u2d5.setUpstreamDataSourceFactory(factory);
                $this$enableCaching_u24lambda_u2d5.setFlags(2);
                factory2 = (DataSource.Factory)factory3;
                return factory2;
            }
        }
        factory2 = factory;
        return factory2;
    }

    private final void requestAudioFocus() {
        int n;
        if (this.hasAudioFocus) {
            return;
        }
        Timber.Forest.d("Requesting audio focus...", new Object[0]);
        AudioManager manager = (AudioManager)ContextCompat.getSystemService((Context)this.context, AudioManager.class);
        this.focus = new AudioFocusRequestCompat.Builder(1).setOnAudioFocusChangeListener((AudioManager.OnAudioFocusChangeListener)this).setAudioAttributes(new AudioAttributesCompat.Builder().setUsage(1).setContentType(2).build()).setWillPauseWhenDucked(this.getPlayerOptions().getAlwaysPauseOnInterruption()).build();
        if (manager != null && this.focus != null) {
            AudioFocusRequestCompat audioFocusRequestCompat = this.focus;
            Intrinsics.checkNotNull((Object)audioFocusRequestCompat);
            n = AudioManagerCompat.requestAudioFocus((AudioManager)manager, (AudioFocusRequestCompat)audioFocusRequestCompat);
        } else {
            n = 0;
        }
        int result = n;
        this.hasAudioFocus = result == 1;
    }

    private final void abandonAudioFocusIfHeld() {
        int n;
        if (!this.hasAudioFocus) {
            return;
        }
        Timber.Forest.d("Abandoning audio focus...", new Object[0]);
        AudioManager manager = (AudioManager)ContextCompat.getSystemService((Context)this.context, AudioManager.class);
        if (manager != null && this.focus != null) {
            AudioFocusRequestCompat audioFocusRequestCompat = this.focus;
            Intrinsics.checkNotNull((Object)audioFocusRequestCompat);
            n = AudioManagerCompat.abandonAudioFocusRequest((AudioManager)manager, (AudioFocusRequestCompat)audioFocusRequestCompat);
        } else {
            n = 0;
        }
        int result = n;
        this.hasAudioFocus = result != 1;
    }

    public void onAudioFocusChange(int focusChange) {
        boolean isPaused;
        Timber.Forest.d("Audio focus changed", new Object[0]);
        boolean isPermanent = focusChange == -1;
        switch (focusChange) {
            case -2: 
            case -1: {
                boolean bl = true;
                break;
            }
            case -3: {
                boolean bl = this.getPlayerOptions().getAlwaysPauseOnInterruption();
                break;
            }
            default: {
                boolean bl = isPaused = false;
            }
        }
        if (!this.playerConfig.getHandleAudioFocus()) {
            boolean isDucking;
            if (isPermanent) {
                this.abandonAudioFocusIfHeld();
            }
            boolean bl = isDucking = focusChange == -3 && !this.getPlayerOptions().getAlwaysPauseOnInterruption();
            if (isDucking) {
                this.setVolumeMultiplier(0.5f);
                this.wasDucking = true;
            } else if (this.wasDucking) {
                this.setVolumeMultiplier(1.0f);
                this.wasDucking = false;
            }
        }
        this.playerEventHolder.updateOnAudioFocusChanged$kotlin_audio_release(isPaused, isPermanent);
    }

    private static final DataSource getMediaSourceFromAudioItem$lambda-2(RawResourceDataSource $raw) {
        Intrinsics.checkNotNullParameter((Object)$raw, (String)"$raw");
        return (DataSource)$raw;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/doublesymmetry/kotlinaudio/players/BaseAudioPlayer$Companion;", "", "()V", "APPLICATION_NAME", "", "kotlin-audio_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/doublesymmetry/kotlinaudio/players/BaseAudioPlayer$PlayerListener;", "Lcom/google/android/exoplayer2/Player$Listener;", "(Lcom/doublesymmetry/kotlinaudio/players/BaseAudioPlayer;)V", "onEvents", "", "player", "Lcom/google/android/exoplayer2/Player;", "events", "Lcom/google/android/exoplayer2/Player$Events;", "onMediaItemTransition", "mediaItem", "Lcom/google/android/exoplayer2/MediaItem;", "reason", "", "onMediaMetadataChanged", "mediaMetadata", "Lcom/google/android/exoplayer2/MediaMetadata;", "onMetadata", "metadata", "Lcom/google/android/exoplayer2/metadata/Metadata;", "onPlayWhenReadyChanged", "playWhenReady", "", "onPlayerError", "error", "Lcom/google/android/exoplayer2/PlaybackException;", "onPositionDiscontinuity", "oldPosition", "Lcom/google/android/exoplayer2/Player$PositionInfo;", "newPosition", "kotlin-audio_release"})
    public final class PlayerListener
    implements Player.Listener {
        public void onMetadata(@NotNull com.google.android.exoplayer2.metadata.Metadata metadata) {
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            BaseAudioPlayer.this.playerEventHolder.updateOnTimedMetadata$kotlin_audio_release(metadata);
        }

        public void onMediaMetadataChanged(@NotNull MediaMetadata mediaMetadata) {
            Intrinsics.checkNotNullParameter((Object)mediaMetadata, (String)"mediaMetadata");
            BaseAudioPlayer.this.playerEventHolder.updateOnCommonMetadata$kotlin_audio_release(mediaMetadata);
        }

        public void onPositionDiscontinuity(@NotNull Player.PositionInfo oldPosition, @NotNull Player.PositionInfo newPosition, int reason) {
            Intrinsics.checkNotNullParameter((Object)oldPosition, (String)"oldPosition");
            Intrinsics.checkNotNullParameter((Object)newPosition, (String)"newPosition");
            BaseAudioPlayer.this.oldPosition = oldPosition.positionMs;
            switch (reason) {
                case 0: {
                    BaseAudioPlayer.this.playerEventHolder.updatePositionChangedReason$kotlin_audio_release(new PositionChangedReason.AUTO(oldPosition.positionMs, newPosition.positionMs));
                    break;
                }
                case 1: {
                    BaseAudioPlayer.this.playerEventHolder.updatePositionChangedReason$kotlin_audio_release(new PositionChangedReason.SEEK(oldPosition.positionMs, newPosition.positionMs));
                    break;
                }
                case 2: {
                    BaseAudioPlayer.this.playerEventHolder.updatePositionChangedReason$kotlin_audio_release(new PositionChangedReason.SEEK_FAILED(oldPosition.positionMs, newPosition.positionMs));
                    break;
                }
                case 4: {
                    BaseAudioPlayer.this.playerEventHolder.updatePositionChangedReason$kotlin_audio_release(new PositionChangedReason.QUEUE_CHANGED(oldPosition.positionMs, newPosition.positionMs));
                    break;
                }
                case 3: {
                    BaseAudioPlayer.this.playerEventHolder.updatePositionChangedReason$kotlin_audio_release(new PositionChangedReason.SKIPPED_PERIOD(oldPosition.positionMs, newPosition.positionMs));
                    break;
                }
                case 5: {
                    BaseAudioPlayer.this.playerEventHolder.updatePositionChangedReason$kotlin_audio_release(new PositionChangedReason.UNKNOWN(oldPosition.positionMs, newPosition.positionMs));
                }
            }
        }

        public void onMediaItemTransition(@Nullable MediaItem mediaItem, int reason) {
            switch (reason) {
                case 1: {
                    BaseAudioPlayer.this.playerEventHolder.updateAudioItemTransition$kotlin_audio_release(new AudioItemTransitionReason.AUTO(BaseAudioPlayer.this.oldPosition));
                    break;
                }
                case 3: {
                    BaseAudioPlayer.this.playerEventHolder.updateAudioItemTransition$kotlin_audio_release(new AudioItemTransitionReason.QUEUE_CHANGED(BaseAudioPlayer.this.oldPosition));
                    break;
                }
                case 0: {
                    BaseAudioPlayer.this.playerEventHolder.updateAudioItemTransition$kotlin_audio_release(new AudioItemTransitionReason.REPEAT(BaseAudioPlayer.this.oldPosition));
                    break;
                }
                case 2: {
                    BaseAudioPlayer.this.playerEventHolder.updateAudioItemTransition$kotlin_audio_release(new AudioItemTransitionReason.SEEK_TO_ANOTHER_AUDIO_ITEM(BaseAudioPlayer.this.oldPosition));
                }
            }
            BaseAudioPlayer.updateNotificationIfNecessary$kotlin_audio_release$default(BaseAudioPlayer.this, null, 1, null);
        }

        public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
            boolean pausedBecauseReachedEnd = reason == 5;
            BaseAudioPlayer.this.playerEventHolder.updatePlayWhenReadyChange$kotlin_audio_release(new PlayWhenReadyChangeData(playWhenReady, pausedBecauseReachedEnd));
        }

        public void onEvents(@NotNull Player player, @NotNull Player.Events events) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            int n = events.size();
            block12: for (int i = 0; i < n; ++i) {
                switch (events.get(i)) {
                    case 4: {
                        AudioPlayerState state;
                        switch (player.getPlaybackState()) {
                            case 2: {
                                AudioPlayerState audioPlayerState = AudioPlayerState.BUFFERING;
                                break;
                            }
                            case 3: {
                                AudioPlayerState audioPlayerState = AudioPlayerState.READY;
                                break;
                            }
                            case 1: {
                                AudioPlayerState audioPlayerState;
                                if (BaseAudioPlayer.this.getPlayerState() == AudioPlayerState.ERROR || BaseAudioPlayer.this.getPlayerState() == AudioPlayerState.STOPPED) {
                                    audioPlayerState = null;
                                    break;
                                }
                                audioPlayerState = AudioPlayerState.IDLE;
                                break;
                            }
                            case 4: {
                                AudioPlayerState audioPlayerState;
                                if (player.getMediaItemCount() > 0) {
                                    audioPlayerState = AudioPlayerState.ENDED;
                                    break;
                                }
                                audioPlayerState = AudioPlayerState.IDLE;
                                break;
                            }
                            default: {
                                AudioPlayerState audioPlayerState = state = null;
                            }
                        }
                        if (state == null || state == BaseAudioPlayer.this.getPlayerState()) continue block12;
                        BaseAudioPlayer.this.setPlayerState(state);
                        continue block12;
                    }
                    case 1: {
                        BaseAudioPlayer.this.setPlaybackError(null);
                        if (BaseAudioPlayer.this.getCurrentItem() == null) continue block12;
                        BaseAudioPlayer.this.setPlayerState(AudioPlayerState.LOADING);
                        if (!BaseAudioPlayer.this.isPlaying()) continue block12;
                        BaseAudioPlayer.this.setPlayerState(AudioPlayerState.READY);
                        BaseAudioPlayer.this.setPlayerState(AudioPlayerState.PLAYING);
                        continue block12;
                    }
                    case 5: {
                        if (player.getPlayWhenReady() || BaseAudioPlayer.this.getPlayerState() == AudioPlayerState.STOPPED) continue block12;
                        BaseAudioPlayer.this.setPlayerState(AudioPlayerState.PAUSED);
                        continue block12;
                    }
                    case 7: {
                        if (!player.isPlaying()) continue block12;
                        BaseAudioPlayer.this.setPlayerState(AudioPlayerState.PLAYING);
                    }
                }
            }
        }

        public void onPlayerError(@NotNull PlaybackException error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            String string2 = error.getErrorCodeName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"error.errorCodeName");
            String string3 = StringsKt.replace$default((String)string2, (String)"ERROR_CODE_", (String)"", (boolean)false, (int)4, null);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string4 = string3.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
            PlaybackError _playbackError = new PlaybackError(StringsKt.replace$default((String)string4, (String)"_", (String)"-", (boolean)false, (int)4, null), error.getMessage());
            BaseAudioPlayer.this.playerEventHolder.updatePlaybackError$kotlin_audio_release(_playbackError);
            BaseAudioPlayer.this.setPlaybackError(_playbackError);
            BaseAudioPlayer.this.setPlayerState(AudioPlayerState.ERROR);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AudioPlayerState.values().length];
            nArray[AudioPlayerState.IDLE.ordinal()] = 1;
            nArray[AudioPlayerState.ERROR.ordinal()] = 2;
            nArray[AudioPlayerState.READY.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MediaType.values().length];
            nArray[MediaType.DASH.ordinal()] = 1;
            nArray[MediaType.HLS.ordinal()] = 2;
            nArray[MediaType.SMOOTH_STREAMING.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

