/*
 * Decompiled with CFR 0.152.
 */
package com.yongbeam.y_photopicker.util.photopicker.adapter;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.support.v4.content.FileProvider;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.yongbeam.y_photopicker.R;
import com.yongbeam.y_photopicker.util.photopicker.PhotoPickerActivity;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PhotoPagerAdapter
extends PagerAdapter {
    private List<String> paths = new ArrayList<String>();
    private Context mContext;
    private LayoutInflater mLayoutInflater;

    public PhotoPagerAdapter(Context mContext, List<String> paths) {
        this.mContext = mContext;
        this.paths = paths;
        this.mLayoutInflater = LayoutInflater.from((Context)mContext);
    }

    public Object instantiateItem(ViewGroup container, int position) {
        View itemView = this.mLayoutInflater.inflate(R.layout.util_item_pager, container, false);
        ImageView imageView = (ImageView)itemView.findViewById(R.id.iv_pager);
        String path = this.paths.get(position);
        Uri uri = path.startsWith("http") ? Uri.parse((String)path) : FileProvider.getUriForFile((Context)this.mContext, (String)"com.yongbeam.y_photopicker.fileprovider", (File)new File(path));
        Glide.with((Context)this.mContext).load(uri).error(R.drawable.ic_place_holder).thumbnail(0.4f).placeholder(R.color.image_loading_error_color).error(R.color.image_loading_error_color).into(imageView);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PhotoPagerAdapter.this.mContext instanceof PhotoPickerActivity && !((Activity)PhotoPagerAdapter.this.mContext).isFinishing()) {
                    ((Activity)PhotoPagerAdapter.this.mContext).onBackPressed();
                }
            }
        });
        container.addView(itemView);
        return itemView;
    }

    public int getCount() {
        return this.paths.size();
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    public int getItemPosition(Object object) {
        return -2;
    }
}

