/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.async;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.core.async.ResponseStreamProcessor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class JsonStreamProcessor<T>
implements ResponseStreamProcessor<T> {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Class<T> clazz;

    public JsonStreamProcessor(Class<T> clazz) {
        this.clazz = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void processResponseStream(InputStream response, ResultCallback<T> resultCallback) {
        resultCallback.onStart((Closeable)response);
        OBJECT_MAPPER.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);
        try {
            JsonParser jp = JSON_FACTORY.createParser(response);
            Boolean closed = jp.isClosed();
            JsonToken nextToken = jp.nextToken();
            while (closed == false) {
                if (nextToken == null) return;
                if (nextToken == JsonToken.END_OBJECT) return;
                try {
                    ObjectNode objectNode = (ObjectNode)OBJECT_MAPPER.readTree(jp);
                    if (!objectNode.isEmpty(null)) {
                        Object next = OBJECT_MAPPER.treeToValue((TreeNode)objectNode, this.clazz);
                        resultCallback.onNext(next);
                    }
                }
                catch (Exception e) {
                    resultCallback.onError((Throwable)e);
                }
                closed = jp.isClosed();
                nextToken = jp.nextToken();
            }
            return;
        }
        catch (Throwable t) {
            resultCallback.onError(t);
            return;
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                resultCallback.onError((Throwable)e);
            }
            finally {
                resultCallback.onComplete();
            }
        }
    }
}

