/*
 * Decompiled with CFR 0.152.
 */
package com.dd.morphingbutton.impl;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import com.dd.morphingbutton.IProgress;
import com.dd.morphingbutton.MorphingButton;

public class LinearProgressButton
extends MorphingButton
implements IProgress {
    public static final int MAX_PROGRESS = 100;
    public static final int MIN_PROGRESS = 0;
    private int mProgress;
    private int mProgressColor;
    private int mProgressCornerRadius;
    private Paint mPaint;
    private RectF mRectF;

    public LinearProgressButton(Context context) {
        super(context);
    }

    public LinearProgressButton(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public LinearProgressButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        if (!this.mAnimationInProgress && this.mProgress > 0 && this.mProgress <= 100) {
            if (this.mPaint == null) {
                this.mPaint = new Paint();
                this.mPaint.setAntiAlias(true);
                this.mPaint.setStyle(Paint.Style.FILL);
                this.mPaint.setColor(this.mProgressColor);
            }
            if (this.mRectF == null) {
                this.mRectF = new RectF();
            }
            this.mRectF.right = (float)this.getWidth() / 100.0f * (float)this.mProgress;
            this.mRectF.bottom = this.getHeight();
            canvas.drawRoundRect(this.mRectF, (float)this.mProgressCornerRadius, (float)this.mProgressCornerRadius, this.mPaint);
        }
    }

    @Override
    public void morph(@NonNull MorphingButton.Params params) {
        super.morph(params);
        this.mProgress = 0;
        this.mPaint = null;
        this.mRectF = null;
    }

    @Override
    public void setProgress(int progress) {
        this.mProgress = progress;
        this.invalidate();
    }

    public void morphToProgress(int color2, int progressColor, int progressCornerRadius, int width, int height, int duration) {
        this.mProgressCornerRadius = progressCornerRadius;
        this.mProgressColor = progressColor;
        MorphingButton.Params longRoundedSquare = MorphingButton.Params.create().duration(duration).cornerRadius(this.mProgressCornerRadius).width(width).height(height).color(color2).colorPressed(color2);
        this.morph(longRoundedSquare);
    }
}

