/*
 * Decompiled with CFR 0.152.
 */
package com.dd.morphingbutton.impl;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import com.dd.morphingbutton.MorphingAnimation;
import com.dd.morphingbutton.MorphingButton;
import com.dd.morphingbutton.R;

public class IndeterminateProgressButton
extends MorphingButton {
    private int mColor1;
    private int mColor2;
    private int mColor3;
    private int mColor4;
    private int mProgressCornerRadius;
    private ProgressBar mProgressBar;
    private boolean mIsRunning;

    public IndeterminateProgressButton(Context context) {
        super(context);
        this.init(context);
    }

    public IndeterminateProgressButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public IndeterminateProgressButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        Resources res = context.getResources();
        this.mColor1 = res.getColor(R.color.mb_gray);
        this.mColor2 = res.getColor(R.color.mb_blue);
        this.mColor3 = res.getColor(R.color.mb_gray);
        this.mColor4 = res.getColor(R.color.mb_blue);
        if (Build.VERSION.SDK_INT <= 18) {
            this.setLayerType(1, null);
        }
    }

    protected void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        if (!this.mAnimationInProgress && this.mIsRunning) {
            if (this.mProgressBar == null) {
                this.mProgressBar = new ProgressBar((View)this);
                this.setupProgressBarBounds();
                this.mProgressBar.setColorScheme(this.mColor1, this.mColor2, this.mColor3, this.mColor4);
                this.mProgressBar.start();
            }
            this.mProgressBar.draw(canvas);
        }
    }

    @Override
    public void morph(@NonNull MorphingButton.Params params) {
        this.mIsRunning = false;
        super.morph(params);
    }

    public void morphToProgress(int backgroundColor, int progressCornerRadius, int width, int height, int duration, int progressColor1) {
        this.morphToProgress(backgroundColor, progressCornerRadius, width, height, duration, backgroundColor, progressColor1, backgroundColor, progressColor1);
    }

    public void morphToProgress(int backgroundColor, int progressCornerRadius, int width, int height, int duration, int progressColor1, int progressColor2) {
        this.morphToProgress(backgroundColor, progressCornerRadius, width, height, duration, progressColor1, progressColor2, progressColor1, progressColor2);
    }

    public void morphToProgress(int backgroundColor, int progressCornerRadius, int width, int height, int duration, int progressColor1, int progressColor2, int progressColor3, int progressColor4) {
        this.mProgressCornerRadius = progressCornerRadius;
        this.mColor1 = progressColor1;
        this.mColor2 = progressColor2;
        this.mColor3 = progressColor3;
        this.mColor4 = progressColor4;
        MorphingButton.Params longRoundedSquare = MorphingButton.Params.create().duration(duration).cornerRadius(this.mProgressCornerRadius).width(width).height(height).color(backgroundColor).colorPressed(backgroundColor).animationListener(new MorphingAnimation.Listener(){

            @Override
            public void onAnimationEnd() {
                IndeterminateProgressButton.this.mIsRunning = true;
                IndeterminateProgressButton.this.invalidate();
            }

            @Override
            public void onAnimationStart() {
            }
        });
        this.morph(longRoundedSquare);
    }

    private void setupProgressBarBounds() {
        double indicatorHeight = this.getHeight();
        int bottom = (int)((double)this.getMeasuredHeight() - indicatorHeight);
        this.mProgressBar.setBounds(0, bottom, this.getMeasuredWidth(), this.getMeasuredHeight(), this.mProgressCornerRadius);
    }

    public static class ProgressBar {
        private static final int COLOR1 = -1291845632;
        private static final int COLOR2 = Integer.MIN_VALUE;
        private static final int COLOR3 = 0x4D000000;
        private static final int COLOR4 = 0x1A000000;
        private static final int ANIMATION_DURATION_MS = 2000;
        private static final int FINISH_ANIMATION_DURATION_MS = 1000;
        private static final Interpolator INTERPOLATOR = new AccelerateDecelerateInterpolator();
        private final Paint mPaint = new Paint();
        private final RectF mClipRect = new RectF();
        private float mTriggerPercentage;
        private long mStartTime;
        private long mFinishTime;
        private boolean mRunning;
        private int mColor1;
        private int mColor2;
        private int mColor3;
        private int mColor4;
        private int mCornerRadius;
        private View mParent;
        private RectF mBounds = new RectF();

        public ProgressBar(View parent) {
            this.mParent = parent;
            this.mColor1 = -1291845632;
            this.mColor2 = Integer.MIN_VALUE;
            this.mColor3 = 0x4D000000;
            this.mColor4 = 0x1A000000;
        }

        void setColorScheme(int color1, int color2, int color3, int color4) {
            this.mColor1 = color1;
            this.mColor2 = color2;
            this.mColor3 = color3;
            this.mColor4 = color4;
        }

        void start() {
            if (!this.mRunning) {
                this.mTriggerPercentage = 0.0f;
                this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                this.mRunning = true;
                this.mParent.postInvalidate();
            }
        }

        void draw(Canvas canvas) {
            Path clipPath = new Path();
            clipPath.addRoundRect(this.mBounds, (float)this.mCornerRadius, (float)this.mCornerRadius, Path.Direction.CW);
            int width = (int)this.mBounds.width();
            int height = (int)this.mBounds.height();
            int cx = width / 2;
            int cy = height / 2;
            boolean drawTriggerWhileFinishing = false;
            int restoreCount = canvas.save();
            canvas.clipPath(clipPath);
            if (this.mRunning || this.mFinishTime > 0L) {
                long now = AnimationUtils.currentAnimationTimeMillis();
                long elapsed = (now - this.mStartTime) % 2000L;
                long iterations = (now - this.mStartTime) / 2000L;
                float rawProgress = (float)elapsed / 20.0f;
                if (!this.mRunning) {
                    if (now - this.mFinishTime >= 1000L) {
                        this.mFinishTime = 0L;
                        return;
                    }
                    long finishElapsed = (now - this.mFinishTime) % 1000L;
                    float finishProgress = (float)finishElapsed / 10.0f;
                    float pct = finishProgress / 100.0f;
                    float clearRadius = (float)(width / 2) * INTERPOLATOR.getInterpolation(pct);
                    this.mClipRect.set((float)cx - clearRadius, 0.0f, (float)cx + clearRadius, (float)height);
                    canvas.saveLayerAlpha(this.mClipRect, 0, 0);
                    drawTriggerWhileFinishing = true;
                }
                if (iterations == 0L) {
                    canvas.drawColor(this.mColor1);
                } else if (rawProgress >= 0.0f && rawProgress < 25.0f) {
                    canvas.drawColor(this.mColor4);
                } else if (rawProgress >= 25.0f && rawProgress < 50.0f) {
                    canvas.drawColor(this.mColor1);
                } else if (rawProgress >= 50.0f && rawProgress < 75.0f) {
                    canvas.drawColor(this.mColor2);
                } else {
                    canvas.drawColor(this.mColor3);
                }
                if (rawProgress >= 0.0f && rawProgress <= 25.0f) {
                    float pct = (rawProgress + 25.0f) * 2.0f / 100.0f;
                    this.drawCircle(canvas, cx, cy, this.mColor1, pct);
                }
                if (rawProgress >= 0.0f && rawProgress <= 50.0f) {
                    float pct = rawProgress * 2.0f / 100.0f;
                    this.drawCircle(canvas, cx, cy, this.mColor2, pct);
                }
                if (rawProgress >= 25.0f && rawProgress <= 75.0f) {
                    float pct = (rawProgress - 25.0f) * 2.0f / 100.0f;
                    this.drawCircle(canvas, cx, cy, this.mColor3, pct);
                }
                if (rawProgress >= 50.0f && rawProgress <= 100.0f) {
                    float pct = (rawProgress - 50.0f) * 2.0f / 100.0f;
                    this.drawCircle(canvas, cx, cy, this.mColor4, pct);
                }
                if (rawProgress >= 75.0f && rawProgress <= 100.0f) {
                    float pct = (rawProgress - 75.0f) * 2.0f / 100.0f;
                    this.drawCircle(canvas, cx, cy, this.mColor1, pct);
                }
                if (this.mTriggerPercentage > 0.0f && drawTriggerWhileFinishing) {
                    canvas.restoreToCount(restoreCount);
                    restoreCount = canvas.save();
                    canvas.clipPath(clipPath);
                    this.drawTrigger(canvas, cx, cy);
                }
                ViewCompat.postInvalidateOnAnimation((View)this.mParent);
            } else if (this.mTriggerPercentage > 0.0f && (double)this.mTriggerPercentage <= 1.0) {
                this.drawTrigger(canvas, cx, cy);
            }
            canvas.restoreToCount(restoreCount);
        }

        private void drawTrigger(Canvas canvas, int cx, int cy) {
            this.mPaint.setColor(this.mColor1);
            canvas.drawCircle((float)cx, (float)cy, (float)cx * this.mTriggerPercentage, this.mPaint);
        }

        private void drawCircle(Canvas canvas, float cx, float cy, int color2, float pct) {
            this.mPaint.setColor(color2);
            canvas.save();
            canvas.translate(cx, cy);
            float radiusScale = INTERPOLATOR.getInterpolation(pct);
            canvas.scale(radiusScale, radiusScale);
            canvas.drawCircle(0.0f, 0.0f, cx, this.mPaint);
            canvas.restore();
        }

        void setBounds(int left, int top, int right, int bottom, int cornerRadius) {
            this.mBounds.left = left;
            this.mBounds.top = top;
            this.mBounds.right = right;
            this.mBounds.bottom = bottom;
            this.mCornerRadius = cornerRadius;
        }
    }
}

