/*
 * Decompiled with CFR 0.152.
 */
package com.dd.morphingbutton;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.StateSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatButton;
import androidx.core.content.ContextCompat;
import com.dd.morphingbutton.MorphingAnimation;
import com.dd.morphingbutton.R;
import com.dd.morphingbutton.StrokeGradientDrawable;

public class MorphingButton
extends AppCompatButton {
    private Padding mPadding;
    private int mHeight;
    private int mWidth;
    private int mColor;
    private int mCornerRadius;
    private int mStrokeWidth;
    private int mStrokeColor;
    protected boolean mAnimationInProgress;
    private StrokeGradientDrawable mDrawableNormal;
    private StrokeGradientDrawable mDrawablePressed;

    public MorphingButton(Context context) {
        super(context);
        this.initView();
    }

    public MorphingButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MorphingButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mHeight == 0 && this.mWidth == 0 && w != 0 && h != 0) {
            this.mHeight = this.getHeight();
            this.mWidth = this.getWidth();
        }
    }

    public StrokeGradientDrawable getDrawableNormal() {
        return this.mDrawableNormal;
    }

    public void morph(@NonNull Params params) {
        if (!this.mAnimationInProgress) {
            this.mDrawablePressed.setColor(params.colorPressed);
            this.mDrawablePressed.setCornerRadius(params.cornerRadius);
            this.mDrawablePressed.setStrokeColor(params.strokeColor);
            this.mDrawablePressed.setStrokeWidth(params.strokeWidth);
            if (params.duration == 0) {
                this.morphWithoutAnimation(params);
            } else {
                this.morphWithAnimation(params);
            }
            this.mColor = params.color;
            this.mCornerRadius = params.cornerRadius;
            this.mStrokeWidth = params.strokeWidth;
            this.mStrokeColor = params.strokeColor;
        }
    }

    private void morphWithAnimation(final @NonNull Params params) {
        this.mAnimationInProgress = true;
        this.setText(null);
        this.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        this.setPadding(this.mPadding.left, this.mPadding.top, this.mPadding.right, this.mPadding.bottom);
        MorphingAnimation.Params animationParams = MorphingAnimation.Params.create(this).color(this.mColor, params.color).cornerRadius(this.mCornerRadius, params.cornerRadius).strokeWidth(this.mStrokeWidth, params.strokeWidth).strokeColor(this.mStrokeColor, params.strokeColor).height(this.getHeight(), params.height).width(this.getWidth(), params.width).duration(params.duration).listener(new MorphingAnimation.Listener(){

            @Override
            public void onAnimationEnd() {
                MorphingButton.this.finalizeMorphing(params);
                MorphingButton.this.setClickable(true);
            }

            @Override
            public void onAnimationStart() {
                MorphingButton.this.setClickable(false);
            }
        });
        MorphingAnimation animation = new MorphingAnimation(animationParams);
        animation.start();
    }

    private void morphWithoutAnimation(@NonNull Params params) {
        this.mDrawableNormal.setColor(params.color);
        this.mDrawableNormal.setCornerRadius(params.cornerRadius);
        this.mDrawableNormal.setStrokeColor(params.strokeColor);
        this.mDrawableNormal.setStrokeWidth(params.strokeWidth);
        if (params.width != 0 && params.height != 0) {
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            layoutParams.width = params.width;
            layoutParams.height = params.height;
            this.setLayoutParams(layoutParams);
        }
        this.finalizeMorphing(params);
    }

    private void finalizeMorphing(@NonNull Params params) {
        this.mAnimationInProgress = false;
        if (params.icon != 0 && params.text != null) {
            this.setIconLeft(params.icon);
            this.setText(params.text);
        } else if (params.icon != 0) {
            this.setIcon(params.icon);
        } else if (params.text != null) {
            this.setText(params.text);
        }
        if (params.animationListener != null) {
            params.animationListener.onAnimationEnd();
        }
    }

    public void blockTouch() {
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
    }

    public void unblockTouch() {
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return false;
            }
        });
    }

    private void initView() {
        this.mPadding = new Padding();
        this.mPadding.left = this.getPaddingLeft();
        this.mPadding.right = this.getPaddingRight();
        this.mPadding.top = this.getPaddingTop();
        this.mPadding.bottom = this.getPaddingBottom();
        Resources resources = this.getResources();
        int cornerRadius = (int)resources.getDimension(R.dimen.mb_corner_radius_2);
        int blue = resources.getColor(R.color.mb_blue);
        int blueDark = resources.getColor(R.color.mb_blue_dark);
        StateListDrawable background = new StateListDrawable();
        this.mDrawableNormal = this.createDrawable(blue, cornerRadius, 0);
        this.mDrawablePressed = this.createDrawable(blueDark, cornerRadius, 0);
        this.mColor = blue;
        this.mStrokeColor = blue;
        this.mCornerRadius = cornerRadius;
        background.addState(new int[]{16842919}, (Drawable)this.mDrawablePressed.getGradientDrawable());
        background.addState(StateSet.WILD_CARD, (Drawable)this.mDrawableNormal.getGradientDrawable());
        this.setBackgroundCompat((Drawable)background);
    }

    private StrokeGradientDrawable createDrawable(int color2, int cornerRadius, int strokeWidth) {
        StrokeGradientDrawable drawable = new StrokeGradientDrawable(new GradientDrawable());
        drawable.getGradientDrawable().setShape(0);
        drawable.setColor(color2);
        drawable.setCornerRadius(cornerRadius);
        drawable.setStrokeColor(color2);
        drawable.setStrokeWidth(strokeWidth);
        return drawable;
    }

    private void setBackgroundCompat(@Nullable Drawable drawable) {
        if (Build.VERSION.SDK_INT <= 16) {
            this.setBackgroundDrawable(drawable);
        } else {
            this.setBackground(drawable);
        }
    }

    public void setIcon(final @DrawableRes int icon) {
        this.post(new Runnable(){

            @Override
            public void run() {
                Drawable drawable = ContextCompat.getDrawable((Context)MorphingButton.this.getContext(), (int)icon);
                int padding = MorphingButton.this.getWidth() / 2 - drawable.getIntrinsicWidth() / 2;
                MorphingButton.this.setCompoundDrawablesWithIntrinsicBounds(icon, 0, 0, 0);
                MorphingButton.this.setPadding(padding, 0, 0, 0);
            }
        });
    }

    public void setIconLeft(@DrawableRes int icon) {
        this.setCompoundDrawablesWithIntrinsicBounds(icon, 0, 0, 0);
    }

    public static class Params {
        private int cornerRadius;
        private int width;
        private int height;
        private int color;
        private int colorPressed;
        private int duration;
        private int icon;
        private int strokeWidth;
        private int strokeColor;
        private String text;
        private MorphingAnimation.Listener animationListener;

        private Params() {
        }

        public static Params create() {
            return new Params();
        }

        public Params text(@NonNull String text) {
            this.text = text;
            return this;
        }

        public Params icon(@DrawableRes int icon) {
            this.icon = icon;
            return this;
        }

        public Params cornerRadius(int cornerRadius) {
            this.cornerRadius = cornerRadius;
            return this;
        }

        public Params width(int width) {
            this.width = width;
            return this;
        }

        public Params height(int height) {
            this.height = height;
            return this;
        }

        public Params color(int color2) {
            this.color = color2;
            return this;
        }

        public Params colorPressed(int colorPressed) {
            this.colorPressed = colorPressed;
            return this;
        }

        public Params duration(int duration) {
            this.duration = duration;
            return this;
        }

        public Params strokeWidth(int strokeWidth) {
            this.strokeWidth = strokeWidth;
            return this;
        }

        public Params strokeColor(int strokeColor) {
            this.strokeColor = strokeColor;
            return this;
        }

        public Params animationListener(MorphingAnimation.Listener animationListener) {
            this.animationListener = animationListener;
            return this;
        }
    }

    private class Padding {
        public int left;
        public int right;
        public int top;
        public int bottom;

        private Padding() {
        }
    }
}

