/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.simpleframework.xml.util.LimitedCache;
import org.simpleframework.xml.util.Match;

public class Resolver<M extends Match>
extends AbstractSet<M> {
    protected final Cache cache;
    protected final Stack stack = new Stack();

    public Resolver() {
        this.cache = new Cache();
    }

    public M resolve(String string) {
        List<M> list = (List<M>)this.cache.get(string);
        if (list == null) {
            list = this.resolveAll(string);
        }
        if (list.isEmpty()) {
            return null;
        }
        return (M)((Match)list.get(0));
    }

    public List<M> resolveAll(String string) {
        List list = (List)this.cache.get(string);
        if (list != null) {
            return list;
        }
        char[] cArray = string.toCharArray();
        if (cArray == null) {
            return null;
        }
        return this.resolveAll(string, cArray);
    }

    private List<M> resolveAll(String string, char[] cArray) {
        ArrayList<Match> arrayList = new ArrayList<Match>();
        for (Match match : this.stack) {
            String string2 = match.getPattern();
            if (!this.match(cArray, string2.toCharArray())) continue;
            this.cache.put(string, arrayList);
            arrayList.add(match);
        }
        return arrayList;
    }

    @Override
    public boolean add(M m) {
        this.stack.push(m);
        return true;
    }

    @Override
    public Iterator<M> iterator() {
        return this.stack.sequence();
    }

    @Override
    public boolean remove(M m) {
        this.cache.clear();
        return this.stack.remove(m);
    }

    @Override
    public int size() {
        return this.stack.size();
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.stack.clear();
    }

    private boolean match(char[] cArray, char[] cArray2) {
        return this.match(cArray, 0, cArray2, 0);
    }

    private boolean match(char[] cArray, int n, char[] cArray2, int n2) {
        while (n2 < cArray2.length && n < cArray.length) {
            if (cArray2[n2] == '*') {
                while (cArray2[n2] == '*') {
                    if (++n2 < cArray2.length) continue;
                    return true;
                }
                if (cArray2[n2] == '?' && ++n2 >= cArray2.length) {
                    return true;
                }
                while (n < cArray.length) {
                    if (cArray[n] == cArray2[n2] || cArray2[n2] == '?') {
                        if (cArray2[n2 - 1] == '?') break;
                        if (this.match(cArray, n, cArray2, n2)) {
                            return true;
                        }
                    }
                    ++n;
                }
                if (cArray.length == n) {
                    return false;
                }
            }
            if (cArray[n++] == cArray2[n2++] || cArray2[n2 - 1] == '?') continue;
            return false;
        }
        if (cArray2.length == n2) {
            return cArray.length == n;
        }
        while (cArray2[n2] == '*') {
            if (++n2 < cArray2.length) continue;
            return true;
        }
        return false;
    }

    private class Stack
    extends LinkedList<M> {
        private Stack() {
        }

        @Override
        public void push(M m) {
            Resolver.this.cache.clear();
            this.addFirst(m);
        }

        public void purge(int n) {
            Resolver.this.cache.clear();
            this.remove(n);
        }

        public Iterator<M> sequence() {
            return new Sequence();
        }

        private class Sequence
        implements Iterator<M> {
            private int cursor;

            public Sequence() {
                this.cursor = Stack.this.size();
            }

            @Override
            public M next() {
                if (this.hasNext()) {
                    return (Match)Stack.this.get(--this.cursor);
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.cursor > 0;
            }

            @Override
            public void remove() {
                Stack.this.purge(this.cursor);
            }
        }
    }

    private class Cache
    extends LimitedCache<List<M>> {
        public Cache() {
            super(1024);
        }
    }
}

