/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import java.text.SimpleDateFormat;
import java.util.Date;

enum DateType {
    FULL("yyyy-MM-dd HH:mm:ss.S z"),
    LONG("yyyy-MM-dd HH:mm:ss z"),
    NORMAL("yyyy-MM-dd z"),
    SHORT("yyyy-MM-dd");

    private DateFormat format;

    private DateType(String string2) {
        this.format = new DateFormat(string2);
    }

    private DateFormat getFormat() {
        return this.format;
    }

    public static String getText(Date date) throws Exception {
        DateFormat dateFormat = FULL.getFormat();
        return dateFormat.getText(date);
    }

    public static Date getDate(String string) throws Exception {
        DateType dateType = DateType.getType(string);
        DateFormat dateFormat = dateType.getFormat();
        return dateFormat.getDate(string);
    }

    public static DateType getType(String string) {
        int n = string.length();
        if (n > 23) {
            return FULL;
        }
        if (n > 20) {
            return LONG;
        }
        if (n > 11) {
            return NORMAL;
        }
        return SHORT;
    }

    private static class DateFormat {
        private SimpleDateFormat format;

        public DateFormat(String string) {
            this.format = new SimpleDateFormat(string);
        }

        public synchronized String getText(Date date) throws Exception {
            return this.format.format(date);
        }

        public synchronized Date getDate(String string) throws Exception {
            return this.format.parse(string);
        }
    }
}

