/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.simpleframework.xml.stream.NamespaceMap;
import org.simpleframework.xml.stream.OutputNode;

class PrefixResolver
extends LinkedHashMap<String, String>
implements NamespaceMap {
    private final OutputNode source;

    public PrefixResolver(OutputNode outputNode) {
        this.source = outputNode;
    }

    @Override
    public String getPrefix() {
        return this.source.getPrefix();
    }

    @Override
    public String setReference(String string) {
        return this.setReference(string, "");
    }

    @Override
    public String setReference(String string, String string2) {
        String string3 = this.resolvePrefix(string);
        if (string3 != null) {
            return null;
        }
        return this.put(string, string2);
    }

    @Override
    public String getPrefix(String string) {
        String string2;
        int n = this.size();
        if (n > 0 && (string2 = (String)this.get(string)) != null) {
            return string2;
        }
        return this.resolvePrefix(string);
    }

    @Override
    public String getReference(String string) {
        if (this.containsValue(string)) {
            for (String string2 : this) {
                String string3 = (String)this.get(string2);
                if (string3 == null || !string3.equals(string)) continue;
                return string2;
            }
        }
        return this.resolveReference(string);
    }

    private String resolveReference(String string) {
        NamespaceMap namespaceMap = this.source.getNamespaces();
        if (namespaceMap != null) {
            return namespaceMap.getReference(string);
        }
        return null;
    }

    private String resolvePrefix(String string) {
        String string2;
        NamespaceMap namespaceMap = this.source.getNamespaces();
        if (namespaceMap != null && !this.containsValue(string2 = namespaceMap.getPrefix(string))) {
            return string2;
        }
        return null;
    }

    @Override
    public Iterator<String> iterator() {
        return this.keySet().iterator();
    }
}

