/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import org.simpleframework.xml.stream.Mode;
import org.simpleframework.xml.stream.NamespaceMap;
import org.simpleframework.xml.stream.NodeWriter;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.OutputNodeMap;
import org.simpleframework.xml.stream.PrefixResolver;

class OutputElement
implements OutputNode {
    private OutputNodeMap table;
    private NamespaceMap scope;
    private NodeWriter writer;
    private OutputNode parent;
    private String reference;
    private String comment;
    private String value;
    private String name;
    private Mode mode;

    public OutputElement(OutputNode outputNode, NodeWriter nodeWriter, String string) {
        this.scope = new PrefixResolver(outputNode);
        this.table = new OutputNodeMap(this);
        this.mode = Mode.INHERIT;
        this.writer = nodeWriter;
        this.parent = outputNode;
        this.name = string;
    }

    @Override
    public String getPrefix() {
        return this.getPrefix(true);
    }

    @Override
    public String getPrefix(boolean bl) {
        String string = this.scope.getPrefix(this.reference);
        if (bl && string == null) {
            return this.parent.getPrefix();
        }
        return string;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String string) {
        this.reference = string;
    }

    @Override
    public NamespaceMap getNamespaces() {
        return this.scope;
    }

    @Override
    public OutputNode getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean isRoot() {
        return this.writer.isRoot(this);
    }

    @Override
    public Mode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public OutputNodeMap getAttributes() {
        return this.table;
    }

    @Override
    public void setComment(String string) {
        this.comment = string;
    }

    @Override
    public void setValue(String string) {
        this.value = string;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void setData(boolean bl) {
        this.mode = bl ? Mode.DATA : Mode.ESCAPE;
    }

    @Override
    public OutputNode setAttribute(String string, String string2) {
        return this.table.put(string, string2);
    }

    @Override
    public OutputNode getChild(String string) throws Exception {
        return this.writer.writeElement(this, string);
    }

    @Override
    public void remove() throws Exception {
        this.writer.remove(this);
    }

    @Override
    public void commit() throws Exception {
        this.writer.commit(this);
    }

    @Override
    public boolean isCommitted() {
        return this.writer.isCommitted(this);
    }

    public String toString() {
        return String.format("element %s", this.name);
    }
}

