/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.reflect.Array;
import org.simpleframework.xml.core.ArrayFactory;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.ElementException;
import org.simpleframework.xml.core.Instance;
import org.simpleframework.xml.core.Primitive;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Position;

class PrimitiveArray
implements Converter {
    private final ArrayFactory factory;
    private final Primitive root;
    private final String parent;
    private final Type entry;
    private final Type type;

    public PrimitiveArray(Context context, Type type, Type type2, String string) {
        this.factory = new ArrayFactory(context, type);
        this.root = new Primitive(context, type2);
        this.parent = string;
        this.entry = type2;
        this.type = type;
    }

    @Override
    public Object read(InputNode inputNode) throws Exception {
        Instance instance = this.factory.getInstance(inputNode);
        Object object = instance.getInstance();
        if (!instance.isReference()) {
            return this.read(inputNode, object);
        }
        return object;
    }

    @Override
    public Object read(InputNode inputNode, Object object) throws Exception {
        int n = Array.getLength(object);
        int n2 = 0;
        while (true) {
            Position position = inputNode.getPosition();
            InputNode inputNode2 = inputNode.getNext();
            if (inputNode2 == null) {
                return object;
            }
            if (n2 >= n) {
                throw new ElementException("Array length missing or incorrect for %s at %s", this.type, position);
            }
            Array.set(object, n2, this.root.read(inputNode2));
            ++n2;
        }
    }

    @Override
    public boolean validate(InputNode inputNode) throws Exception {
        Instance instance = this.factory.getInstance(inputNode);
        if (!instance.isReference()) {
            Object object = instance.setInstance(null);
            Class clazz = instance.getType();
            return this.validate(inputNode, clazz);
        }
        return true;
    }

    private boolean validate(InputNode inputNode, Class clazz) throws Exception {
        InputNode inputNode2;
        while ((inputNode2 = inputNode.getNext()) != null) {
            this.root.validate(inputNode2);
        }
        return true;
    }

    @Override
    public void write(OutputNode outputNode, Object object) throws Exception {
        OutputNode outputNode2;
        int n = Array.getLength(object);
        for (int i = 0; i < n && (outputNode2 = outputNode.getChild(this.parent)) != null; ++i) {
            this.write(outputNode2, object, i);
        }
    }

    private void write(OutputNode outputNode, Object object, int n) throws Exception {
        Object object2 = Array.get(object, n);
        if (object2 != null && !this.isOverridden(outputNode, object2)) {
            this.root.write(outputNode, object2);
        }
    }

    private boolean isOverridden(OutputNode outputNode, Object object) throws Exception {
        return this.factory.setOverride(this.entry, object, outputNode);
    }
}

