/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import org.simpleframework.xml.Path;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.EmptyExpression;
import org.simpleframework.xml.core.Expression;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.PathParser;
import org.simpleframework.xml.core.Reflector;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.Format;

class Introspector {
    private final Annotation marker;
    private final Contact contact;
    private final Format format;
    private final Label label;

    public Introspector(Contact contact, Label label, Format format) {
        this.marker = contact.getAnnotation();
        this.contact = contact;
        this.format = format;
        this.label = label;
    }

    public Contact getContact() {
        return this.contact;
    }

    public Type getDependent() throws Exception {
        return this.label.getDependent();
    }

    public String getEntry() throws Exception {
        Type type = this.getDependent();
        Class<?> clazz = type.getType();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return this.getName(clazz);
    }

    private String getName(Class clazz) throws Exception {
        String string = this.getRoot(clazz);
        if (string != null) {
            return string;
        }
        string = clazz.getSimpleName();
        return Reflector.getName(string);
    }

    private String getRoot(Class clazz) {
        Class clazz2 = clazz;
        while (clazz != null) {
            String string = this.getRoot(clazz2, clazz);
            if (string != null) {
                return string;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private String getRoot(Class<?> clazz, Class<?> clazz2) {
        String string = clazz2.getSimpleName();
        Root root = clazz2.getAnnotation(Root.class);
        if (root != null) {
            String string2 = root.name();
            if (!this.isEmpty(string2)) {
                return string2;
            }
            return Reflector.getName(string);
        }
        return null;
    }

    public String getName() throws Exception {
        String string = this.label.getEntry();
        if (!this.label.isInline()) {
            string = this.getDefault();
        }
        return string;
    }

    private String getDefault() throws Exception {
        String string = this.label.getOverride();
        if (!this.isEmpty(string)) {
            return string;
        }
        return this.contact.getName();
    }

    public Expression getExpression() throws Exception {
        String string = this.getPath();
        if (string != null) {
            return new PathParser(string, this.contact, this.format);
        }
        return new EmptyExpression(this.format);
    }

    public String getPath() throws Exception {
        Path path = this.contact.getAnnotation(Path.class);
        if (path == null) {
            return null;
        }
        return path.value();
    }

    public boolean isEmpty(String string) {
        if (string != null) {
            return string.length() == 0;
        }
        return true;
    }

    public String toString() {
        return String.format("%s on %s", this.marker, this.contact);
    }
}

