/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.simpleframework.xml.core.CacheParameter;
import org.simpleframework.xml.core.ClassInstantiator;
import org.simpleframework.xml.core.Comparer;
import org.simpleframework.xml.core.ConstructorException;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Creator;
import org.simpleframework.xml.core.Detail;
import org.simpleframework.xml.core.Instantiator;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.LabelMap;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.ParameterMap;
import org.simpleframework.xml.core.Scanner;
import org.simpleframework.xml.core.Signature;
import org.simpleframework.xml.core.SignatureCreator;
import org.simpleframework.xml.core.Support;

class InstantiatorBuilder {
    private List<Creator> options = new ArrayList<Creator>();
    private Instantiator factory;
    private LabelMap attributes;
    private LabelMap elements;
    private LabelMap texts;
    private Comparer comparer = new Comparer();
    private Scanner scanner;
    private Detail detail;

    public InstantiatorBuilder(Scanner scanner, Detail detail) {
        this.attributes = new LabelMap();
        this.elements = new LabelMap();
        this.texts = new LabelMap();
        this.scanner = scanner;
        this.detail = detail;
    }

    public Instantiator build() throws Exception {
        if (this.factory == null) {
            this.populate(this.detail);
            this.build(this.detail);
            this.validate(this.detail);
        }
        return this.factory;
    }

    private Instantiator build(Detail detail) throws Exception {
        if (this.factory == null) {
            this.factory = this.create(detail);
        }
        return this.factory;
    }

    private Instantiator create(Detail detail) throws Exception {
        Signature signature = this.scanner.getSignature();
        ParameterMap parameterMap = this.scanner.getParameters();
        SignatureCreator signatureCreator = null;
        if (signature != null) {
            signatureCreator = new SignatureCreator(signature);
        }
        return new ClassInstantiator(this.options, signatureCreator, parameterMap, detail);
    }

    private Creator create(Signature signature) {
        SignatureCreator signatureCreator = new SignatureCreator(signature);
        if (signature != null) {
            this.options.add(signatureCreator);
        }
        return signatureCreator;
    }

    private Parameter create(Parameter parameter) throws Exception {
        Label label = this.resolve(parameter);
        if (label != null) {
            return new CacheParameter(parameter, label);
        }
        return null;
    }

    private void populate(Detail detail) throws Exception {
        List<Signature> list = this.scanner.getSignatures();
        for (Signature signature : list) {
            this.populate(signature);
        }
    }

    private void populate(Signature signature) throws Exception {
        Signature signature2 = new Signature(signature);
        for (Parameter parameter : signature) {
            Parameter parameter2 = this.create(parameter);
            if (parameter2 == null) continue;
            signature2.add(parameter2);
        }
        this.create(signature2);
    }

    private void validate(Detail detail) throws Exception {
        ParameterMap parameterMap = this.scanner.getParameters();
        List<Parameter> list = parameterMap.getAll();
        for (Parameter parameter : list) {
            Label label = this.resolve(parameter);
            String string = parameter.getPath();
            if (label == null) {
                throw new ConstructorException("Parameter '%s' does not have a match in %s", string, detail);
            }
            this.validateParameter(label, parameter);
        }
        this.validateConstructors();
    }

    private void validateParameter(Label label, Parameter parameter) throws Exception {
        Class clazz;
        Contact contact = label.getContact();
        String string = parameter.getName();
        Class clazz2 = parameter.getType();
        if (!Support.isAssignable(clazz2, clazz = contact.getType())) {
            throw new ConstructorException("Type is not compatible with %s for '%s' in %s", label, string, parameter);
        }
        this.validateNames(label, parameter);
        this.validateAnnotations(label, parameter);
    }

    private void validateNames(Label label, Parameter parameter) throws Exception {
        String string;
        String string2;
        String[] stringArray = label.getNames();
        if (!this.contains(stringArray, string2 = parameter.getName()) && string2 != (string = label.getName())) {
            if (string2 == null || string == null) {
                throw new ConstructorException("Annotation does not match %s for '%s' in %s", label, string2, parameter);
            }
            if (!string2.equals(string)) {
                throw new ConstructorException("Annotation does not match %s for '%s' in %s", label, string2, parameter);
            }
        }
    }

    private void validateAnnotations(Label label, Parameter parameter) throws Exception {
        Class<? extends Annotation> clazz;
        Class<? extends Annotation> clazz2;
        Annotation annotation = label.getAnnotation();
        Annotation annotation2 = parameter.getAnnotation();
        String string = parameter.getName();
        if (!this.comparer.equals(annotation, annotation2) && !(clazz2 = annotation.annotationType()).equals(clazz = annotation2.annotationType())) {
            throw new ConstructorException("Annotation %s does not match %s for '%s' in %s", clazz, clazz2, string, parameter);
        }
    }

    private void validateConstructors() throws Exception {
        List<Creator> list = this.factory.getCreators();
        if (this.factory.isDefault()) {
            this.validateConstructors(this.elements);
            this.validateConstructors(this.attributes);
        }
        if (!list.isEmpty()) {
            this.validateConstructors(this.elements, list);
            this.validateConstructors(this.attributes, list);
        }
    }

    private void validateConstructors(LabelMap labelMap) throws Exception {
        for (Label label : labelMap) {
            Contact contact;
            if (label == null || !(contact = label.getContact()).isReadOnly()) continue;
            throw new ConstructorException("Default constructor can not accept read only %s in %s", label, this.detail);
        }
    }

    private void validateConstructors(LabelMap labelMap, List<Creator> list) throws Exception {
        for (Label label : labelMap) {
            if (label == null) continue;
            this.validateConstructor(label, list);
        }
        if (list.isEmpty()) {
            throw new ConstructorException("No constructor accepts all read only values in %s", this.detail);
        }
    }

    private void validateConstructor(Label label, List<Creator> list) throws Exception {
        Iterator<Creator> iterator = list.iterator();
        while (iterator.hasNext()) {
            Parameter parameter;
            Creator creator = iterator.next();
            Signature signature = creator.getSignature();
            Contact contact = label.getContact();
            Object object = label.getKey();
            if (!contact.isReadOnly() || (parameter = signature.get(object)) != null) continue;
            iterator.remove();
        }
    }

    public void register(Label label) throws Exception {
        if (label.isAttribute()) {
            this.register(label, this.attributes);
        } else if (label.isText()) {
            this.register(label, this.texts);
        } else {
            this.register(label, this.elements);
        }
    }

    private void register(Label label, LabelMap labelMap) throws Exception {
        String string = label.getName();
        String string2 = label.getPath();
        if (labelMap.containsKey(string)) {
            Label label2 = (Label)labelMap.get(string);
            String string3 = label2.getPath();
            if (!string3.equals(string)) {
                labelMap.remove(string);
            }
        } else {
            labelMap.put(string, label);
        }
        labelMap.put(string2, label);
    }

    private Label resolve(Parameter parameter) throws Exception {
        if (parameter.isAttribute()) {
            return this.resolve(parameter, this.attributes);
        }
        if (parameter.isText()) {
            return this.resolve(parameter, this.texts);
        }
        return this.resolve(parameter, this.elements);
    }

    private Label resolve(Parameter parameter, LabelMap labelMap) throws Exception {
        String string = parameter.getName();
        String string2 = parameter.getPath();
        Label label = (Label)labelMap.get(string2);
        if (label == null) {
            return (Label)labelMap.get(string);
        }
        return label;
    }

    private boolean contains(String[] stringArray, String string) throws Exception {
        for (String string2 : stringArray) {
            if (string2 == string) {
                return true;
            }
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }
}

