/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.core.ArrayFactory;
import org.simpleframework.xml.core.ClassType;
import org.simpleframework.xml.core.CompositeArray;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.core.Expression;
import org.simpleframework.xml.core.Factory;
import org.simpleframework.xml.core.InstantiationException;
import org.simpleframework.xml.core.Introspector;
import org.simpleframework.xml.core.PrimitiveArray;
import org.simpleframework.xml.core.Qualifier;
import org.simpleframework.xml.core.TemplateLabel;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.Style;

class ElementArrayLabel
extends TemplateLabel {
    private Decorator decorator;
    private ElementArray label;
    private Introspector detail;
    private Expression path;
    private Format format;
    private Class type;
    private String entry;
    private String name;
    private boolean required;
    private boolean data;

    public ElementArrayLabel(Contact contact, ElementArray elementArray, Format format) {
        this.detail = new Introspector(contact, this, format);
        this.decorator = new Qualifier(contact);
        this.required = elementArray.required();
        this.type = contact.getType();
        this.entry = elementArray.entry();
        this.data = elementArray.data();
        this.name = elementArray.name();
        this.format = format;
        this.label = elementArray;
    }

    @Override
    public Decorator getDecorator() throws Exception {
        return this.decorator;
    }

    @Override
    public Converter getConverter(Context context) throws Exception {
        Contact contact = this.getContact();
        String string = this.getEntry();
        if (!this.type.isArray()) {
            throw new InstantiationException("Type is not an array %s for %s", this.type, contact);
        }
        return this.getConverter(context, string);
    }

    private Converter getConverter(Context context, String string) throws Exception {
        Type type = this.getDependent();
        Contact contact = this.getContact();
        if (!context.isPrimitive(type)) {
            return new CompositeArray(context, contact, type, string);
        }
        return new PrimitiveArray(context, contact, type, string);
    }

    @Override
    public Object getEmpty(Context context) throws Exception {
        ClassType classType = new ClassType(this.type);
        ArrayFactory arrayFactory = new ArrayFactory(context, classType);
        if (!this.label.empty()) {
            return ((Factory)arrayFactory).getInstance();
        }
        return null;
    }

    @Override
    public String getEntry() throws Exception {
        Style style = this.format.getStyle();
        if (this.detail.isEmpty(this.entry)) {
            this.entry = this.detail.getEntry();
        }
        return style.getElement(this.entry);
    }

    @Override
    public String getName() throws Exception {
        Style style = this.format.getStyle();
        String string = this.detail.getName();
        return style.getElement(string);
    }

    @Override
    public String getPath() throws Exception {
        Expression expression = this.getExpression();
        String string = this.getName();
        return expression.getElement(string);
    }

    @Override
    public Expression getExpression() throws Exception {
        if (this.path == null) {
            this.path = this.detail.getExpression();
        }
        return this.path;
    }

    @Override
    public Annotation getAnnotation() {
        return this.label;
    }

    @Override
    public Type getDependent() {
        Class<?> clazz = this.type.getComponentType();
        if (clazz == null) {
            return new ClassType(this.type);
        }
        return new ClassType(clazz);
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public Contact getContact() {
        return this.detail.getContact();
    }

    @Override
    public String getOverride() {
        return this.name;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean isData() {
        return this.data;
    }

    @Override
    public String toString() {
        return this.detail.toString();
    }
}

