/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.core.ConstructorException;
import org.simpleframework.xml.core.Detail;
import org.simpleframework.xml.core.ParameterMap;
import org.simpleframework.xml.core.Signature;
import org.simpleframework.xml.core.SignatureScanner;
import org.simpleframework.xml.core.Support;

class ConstructorScanner {
    private List<Signature> signatures = new ArrayList<Signature>();
    private ParameterMap registry = new ParameterMap();
    private Signature primary;
    private Support support;

    public ConstructorScanner(Detail detail, Support support) throws Exception {
        this.support = support;
        this.scan(detail);
    }

    public Signature getSignature() {
        return this.primary;
    }

    public List<Signature> getSignatures() {
        return new ArrayList<Signature>(this.signatures);
    }

    public ParameterMap getParameters() {
        return this.registry;
    }

    private void scan(Detail detail) throws Exception {
        Constructor[] constructorArray = detail.getConstructors();
        if (!detail.isInstantiable()) {
            throw new ConstructorException("Can not construct inner %s", detail);
        }
        for (Constructor constructor : constructorArray) {
            if (detail.isPrimitive()) continue;
            this.scan(constructor);
        }
    }

    private void scan(Constructor constructor) throws Exception {
        SignatureScanner signatureScanner = new SignatureScanner(constructor, this.registry, this.support);
        if (signatureScanner.isValid()) {
            List<Signature> list = signatureScanner.getSignatures();
            for (Signature signature : list) {
                int n = signature.size();
                if (n == 0) {
                    this.primary = signature;
                }
                this.signatures.add(signature);
            }
        }
    }
}

