/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.Map;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Entry;
import org.simpleframework.xml.core.Instance;
import org.simpleframework.xml.core.MapFactory;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Style;

class CompositeMap
implements Converter {
    private final MapFactory factory;
    private final Converter value;
    private final Converter key;
    private final Style style;
    private final Entry entry;

    public CompositeMap(Context context, Entry entry, Type type) throws Exception {
        this.factory = new MapFactory(context, type);
        this.value = entry.getValue(context);
        this.key = entry.getKey(context);
        this.style = context.getStyle();
        this.entry = entry;
    }

    @Override
    public Object read(InputNode inputNode) throws Exception {
        Instance instance = this.factory.getInstance(inputNode);
        Object object = instance.getInstance();
        if (!instance.isReference()) {
            return this.populate(inputNode, object);
        }
        return object;
    }

    @Override
    public Object read(InputNode inputNode, Object object) throws Exception {
        Instance instance = this.factory.getInstance(inputNode);
        if (instance.isReference()) {
            return instance.getInstance();
        }
        instance.setInstance(object);
        if (object != null) {
            return this.populate(inputNode, object);
        }
        return object;
    }

    private Object populate(InputNode inputNode, Object object) throws Exception {
        Map map = (Map)object;
        InputNode inputNode2;
        while ((inputNode2 = inputNode.getNext()) != null) {
            Object object2 = this.key.read(inputNode2);
            Object object3 = this.value.read(inputNode2);
            map.put(object2, object3);
        }
        return map;
    }

    @Override
    public boolean validate(InputNode inputNode) throws Exception {
        Instance instance = this.factory.getInstance(inputNode);
        if (!instance.isReference()) {
            Object object = instance.setInstance(null);
            Class clazz = instance.getType();
            return this.validate(inputNode, clazz);
        }
        return true;
    }

    private boolean validate(InputNode inputNode, Class clazz) throws Exception {
        InputNode inputNode2;
        do {
            if ((inputNode2 = inputNode.getNext()) == null) {
                return true;
            }
            if (this.key.validate(inputNode2)) continue;
            return false;
        } while (this.value.validate(inputNode2));
        return false;
    }

    @Override
    public void write(OutputNode outputNode, Object object) throws Exception {
        Map map = (Map)object;
        for (Object k : map.keySet()) {
            String string = this.entry.getEntry();
            String string2 = this.style.getElement(string);
            OutputNode outputNode2 = outputNode.getChild(string2);
            Object v = map.get(k);
            this.key.write(outputNode2, k);
            this.value.write(outputNode2, v);
        }
    }
}

