/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.Collection;
import org.simpleframework.xml.core.CollectionFactory;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Instance;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Traverser;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

class CompositeList
implements Converter {
    private final CollectionFactory factory;
    private final Traverser root;
    private final String name;
    private final Type entry;
    private final Type type;

    public CompositeList(Context context, Type type, Type type2, String string) {
        this.factory = new CollectionFactory(context, type);
        this.root = new Traverser(context);
        this.entry = type2;
        this.type = type;
        this.name = string;
    }

    @Override
    public Object read(InputNode inputNode) throws Exception {
        Instance instance = this.factory.getInstance(inputNode);
        Object object = instance.getInstance();
        if (!instance.isReference()) {
            return this.populate(inputNode, object);
        }
        return object;
    }

    @Override
    public Object read(InputNode inputNode, Object object) throws Exception {
        Instance instance = this.factory.getInstance(inputNode);
        if (instance.isReference()) {
            return instance.getInstance();
        }
        instance.setInstance(object);
        if (object != null) {
            return this.populate(inputNode, object);
        }
        return object;
    }

    private Object populate(InputNode inputNode, Object object) throws Exception {
        Collection collection = (Collection)object;
        while (true) {
            InputNode inputNode2 = inputNode.getNext();
            Class clazz = this.entry.getType();
            if (inputNode2 == null) {
                return collection;
            }
            collection.add(this.root.read(inputNode2, clazz));
        }
    }

    @Override
    public boolean validate(InputNode inputNode) throws Exception {
        Instance instance = this.factory.getInstance(inputNode);
        if (!instance.isReference()) {
            Object object = instance.setInstance(null);
            Class clazz = instance.getType();
            return this.validate(inputNode, clazz);
        }
        return true;
    }

    private boolean validate(InputNode inputNode, Class clazz) throws Exception {
        while (true) {
            InputNode inputNode2 = inputNode.getNext();
            Class clazz2 = this.entry.getType();
            if (inputNode2 == null) {
                return true;
            }
            this.root.validate(inputNode2, clazz2);
        }
    }

    @Override
    public void write(OutputNode outputNode, Object object) throws Exception {
        Collection collection = (Collection)object;
        for (Object e : collection) {
            Class<?> clazz;
            if (e == null) continue;
            Class clazz2 = this.entry.getType();
            if (!clazz2.isAssignableFrom(clazz = e.getClass())) {
                throw new PersistenceException("Entry %s does not match %s for %s", clazz, this.entry, this.type);
            }
            this.root.write(outputNode, e, clazz2, this.name);
        }
    }
}

