/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.Collection;
import org.simpleframework.xml.core.CollectionFactory;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Repeater;
import org.simpleframework.xml.core.Traverser;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

class CompositeInlineList
implements Repeater {
    private final CollectionFactory factory;
    private final Traverser root;
    private final String name;
    private final Type entry;
    private final Type type;

    public CompositeInlineList(Context context, Type type, Type type2, String string) {
        this.factory = new CollectionFactory(context, type);
        this.root = new Traverser(context);
        this.entry = type2;
        this.type = type;
        this.name = string;
    }

    @Override
    public Object read(InputNode inputNode) throws Exception {
        Object object = this.factory.getInstance();
        Collection collection = (Collection)object;
        if (collection != null) {
            return this.read(inputNode, collection);
        }
        return null;
    }

    @Override
    public Object read(InputNode inputNode, Object object) throws Exception {
        Collection collection = (Collection)object;
        if (collection != null) {
            return this.read(inputNode, collection);
        }
        return this.read(inputNode);
    }

    private Object read(InputNode inputNode, Collection collection) throws Exception {
        InputNode inputNode2 = inputNode.getParent();
        String string = inputNode.getName();
        while (inputNode != null) {
            Class clazz = this.entry.getType();
            Object object = this.read(inputNode, clazz);
            if (object != null) {
                collection.add(object);
            }
            inputNode = inputNode2.getNext(string);
        }
        return collection;
    }

    private Object read(InputNode inputNode, Class clazz) throws Exception {
        Object object = this.root.read(inputNode, clazz);
        Class<?> clazz2 = object.getClass();
        Class clazz3 = this.entry.getType();
        if (!clazz3.isAssignableFrom(clazz2)) {
            throw new PersistenceException("Entry %s does not match %s for %s", clazz2, this.entry, this.type);
        }
        return object;
    }

    @Override
    public boolean validate(InputNode inputNode) throws Exception {
        InputNode inputNode2 = inputNode.getParent();
        Class clazz = this.entry.getType();
        String string = inputNode.getName();
        while (inputNode != null) {
            boolean bl = this.root.validate(inputNode, clazz);
            if (!bl) {
                return false;
            }
            inputNode = inputNode2.getNext(string);
        }
        return true;
    }

    @Override
    public void write(OutputNode outputNode, Object object) throws Exception {
        Collection collection = (Collection)object;
        OutputNode outputNode2 = outputNode.getParent();
        if (!outputNode.isCommitted()) {
            outputNode.remove();
        }
        this.write(outputNode2, collection);
    }

    public void write(OutputNode outputNode, Collection collection) throws Exception {
        for (Object e : collection) {
            Class<?> clazz;
            if (e == null) continue;
            Class clazz2 = this.entry.getType();
            if (!clazz2.isAssignableFrom(clazz = e.getClass())) {
                throw new PersistenceException("Entry %s does not match %s for %s", clazz, clazz2, this.type);
            }
            this.root.write(outputNode, e, clazz2, this.name);
        }
    }
}

