/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.core.Creator;
import org.simpleframework.xml.core.Criteria;
import org.simpleframework.xml.core.Detail;
import org.simpleframework.xml.core.Instantiator;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.ParameterMap;
import org.simpleframework.xml.core.PersistenceException;

class ClassInstantiator
implements Instantiator {
    private final List<Creator> creators;
    private final ParameterMap registry;
    private final Creator primary;
    private final Detail detail;

    public ClassInstantiator(List<Creator> list, Creator creator, ParameterMap parameterMap, Detail detail) {
        this.creators = list;
        this.registry = parameterMap;
        this.primary = creator;
        this.detail = detail;
    }

    @Override
    public boolean isDefault() {
        int n = this.creators.size();
        if (n <= 1) {
            return this.primary != null;
        }
        return false;
    }

    @Override
    public Object getInstance() throws Exception {
        return this.primary.getInstance();
    }

    @Override
    public Object getInstance(Criteria criteria) throws Exception {
        Creator creator = this.getCreator(criteria);
        if (creator == null) {
            throw new PersistenceException("Constructor not matched for %s", this.detail);
        }
        return creator.getInstance(criteria);
    }

    private Creator getCreator(Criteria criteria) throws Exception {
        Creator creator = this.primary;
        double d = 0.0;
        for (Creator creator2 : this.creators) {
            double d2 = creator2.getScore(criteria);
            if (!(d2 > d)) continue;
            creator = creator2;
            d = d2;
        }
        return creator;
    }

    @Override
    public Parameter getParameter(String string) {
        return (Parameter)this.registry.get(string);
    }

    @Override
    public List<Parameter> getParameters() {
        return this.registry.getAll();
    }

    @Override
    public List<Creator> getCreators() {
        return new ArrayList<Creator>(this.creators);
    }

    public String toString() {
        return String.format("creator for %s", this.detail);
    }
}

