/*
 * Decompiled with CFR 0.152.
 */
package com.ecs.rdlibrary.utils;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import com.ecs.rdlibrary.utils.DeviceModel;
import java.util.HashMap;

public class DeviceUtils {
    public static DeviceModel getConnectedDeviceModel(Context context) {
        UsbManager usbManager = (UsbManager)context.getSystemService("usb");
        HashMap hashMap = usbManager.getDeviceList();
        if (hashMap.size() > 0) {
            for (UsbDevice usbDevice : hashMap.values()) {
                if (usbDevice.getVendorId() == 3018) {
                    return DeviceModel.Startek;
                }
                if (usbDevice.getVendorId() == 1204 || usbDevice.getVendorId() == 11279) {
                    return DeviceModel.Mantra;
                }
                if (usbDevice.getVendorId() == 1947 || usbDevice.getVendorId() == 8797) {
                    return DeviceModel.Morpho;
                }
                if (usbDevice.getVendorId() == 4450) {
                    return DeviceModel.Secugen;
                }
                if (usbDevice.getVendorId() == 8457 || usbDevice.getVendorId() == 11576) {
                    if (usbDevice.getProductId() != 2010 && usbDevice.getProductId() != 30264 && usbDevice.getProductId() != 2000) continue;
                    return DeviceModel.Precision_PB510;
                }
                if (usbDevice.getVendorId() == 8035) {
                    return DeviceModel.Iritek_MK2120U;
                }
                return DeviceModel.Unknown;
            }
        }
        return DeviceModel.Unknown;
    }

    public static String getPackageName(DeviceModel deviceModel) {
        switch (deviceModel) {
            case Morpho: {
                return "com.scl.rdservice";
            }
            case Secugen: {
                return "com.secugen.rdservice";
            }
            case Mantra: {
                return "com.mantra.rdservice";
            }
            case Startek: {
                return "com.acpl.registersdk";
            }
            case Precision_PB510: {
                return "com.precision.pb510.rdservice";
            }
            case Iritek_MK2120U: {
                return "com.access.iris_RD";
            }
        }
        return "unknown";
    }
}

