/*
 * Decompiled with CFR 0.152.
 */
package com.github.dfqin.grantor;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.PermissionChecker;
import android.util.Log;
import com.github.dfqin.grantor.PermissionActivity;
import com.github.dfqin.grantor.PermissionListener;
import java.io.Serializable;
import java.util.HashMap;

public class PermissionsUtil {
    public static final String TAG = "PermissionGrantor";
    private static HashMap<String, PermissionListener> listenerMap = new HashMap();

    public static void requestPermission(Context context, PermissionListener listener, String ... permission) {
        PermissionsUtil.requestPermission(context, listener, permission, true, null);
    }

    public static void requestPermission(@NonNull Context context, @NonNull PermissionListener listener, @NonNull String[] permission, boolean showTip, @Nullable TipInfo tip) {
        if (listener == null) {
            Log.e((String)TAG, (String)"listener is null");
            return;
        }
        if (PermissionsUtil.hasPermission(context, permission)) {
            listener.permissionGranted(permission);
        } else if (Build.VERSION.SDK_INT < 23) {
            listener.permissionDenied(permission);
        } else {
            String key = String.valueOf(System.currentTimeMillis());
            listenerMap.put(key, listener);
            Intent intent = new Intent(context, PermissionActivity.class);
            intent.putExtra("permission", permission);
            intent.putExtra("key", key);
            intent.putExtra("showTip", showTip);
            intent.putExtra("tip", (Serializable)tip);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    public static boolean hasPermission(@NonNull Context context, String ... permissions) {
        if (permissions.length == 0) {
            return false;
        }
        for (String per : permissions) {
            int result = PermissionChecker.checkSelfPermission((Context)context, (String)per);
            if (result == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isGranted(int ... grantResult) {
        if (grantResult.length == 0) {
            return false;
        }
        for (int result : grantResult) {
            if (result == 0) continue;
            return false;
        }
        return true;
    }

    public static void gotoSetting(@NonNull Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + context.getPackageName())));
        context.startActivity(intent);
    }

    static PermissionListener fetchListener(String key) {
        return listenerMap.remove(key);
    }

    public static class TipInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String title;
        String content;
        String cancel;
        String ensure;

        public TipInfo(@Nullable String title, @Nullable String content, @Nullable String cancel, @Nullable String ensure) {
            this.title = title;
            this.content = content;
            this.cancel = cancel;
            this.ensure = ensure;
        }
    }
}

