/*
 * Decompiled with CFR 0.152.
 */
package com.github.dewinjm.monthyearpicker;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import com.github.dewinjm.monthyearpicker.MonthFormat;
import com.github.dewinjm.monthyearpicker.MonthYearPickerDialog;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Locale;

public class MonthYearPickerDialogFragment
extends DialogFragment {
    public static final int NULL_INT = -1;
    private static final String ARG_MONTH = "month";
    private static final String ARG_YEAR = "year";
    private static final String ARG_TITLE = "title";
    private static final String ARG_MIN_DATE = "min_date";
    private static final String ARG_MAX_DATE = "max_date";
    private static final String ARG_LOCALE = "locale";
    private static final String ARG_MONTH_FORMAT = "monthFormat";
    private MonthYearPickerDialog.OnDateSetListener onDateSetListener;

    public static MonthYearPickerDialogFragment getInstance(int month, int year) {
        return MonthYearPickerDialogFragment.getInstance(month, year, -1L, -1L, null);
    }

    public static MonthYearPickerDialogFragment getInstance(int month, int year, String title) {
        return MonthYearPickerDialogFragment.getInstance(month, year, -1L, -1L, title);
    }

    public static MonthYearPickerDialogFragment getInstance(int month, int year, String title, Locale locale) {
        return MonthYearPickerDialogFragment.getInstance(month, year, -1L, -1L, title, locale, MonthFormat.SHORT);
    }

    public static MonthYearPickerDialogFragment getInstance(int month, int year, String title, MonthFormat monthFormat) {
        return MonthYearPickerDialogFragment.getInstance(month, year, -1L, -1L, title, null, monthFormat);
    }

    public static MonthYearPickerDialogFragment getInstance(int month, int year, String title, Locale locale, MonthFormat monthFormat) {
        return MonthYearPickerDialogFragment.getInstance(month, year, -1L, -1L, title, locale, monthFormat);
    }

    public static MonthYearPickerDialogFragment getInstance(int month, int year, long minDate, long maxDate) {
        return MonthYearPickerDialogFragment.getInstance(month, year, minDate, maxDate, null);
    }

    public static MonthYearPickerDialogFragment getInstance(int month, int year, long minDate, long maxDate, String title) {
        return MonthYearPickerDialogFragment.getInstance(month, year, minDate, maxDate, title, MonthFormat.SHORT);
    }

    public static MonthYearPickerDialogFragment getInstance(int month, int year, long minDate, long maxDate, String title, Locale locale) {
        return MonthYearPickerDialogFragment.getInstance(month, year, minDate, maxDate, title, locale, MonthFormat.SHORT);
    }

    public static MonthYearPickerDialogFragment getInstance(int month, int year, long minDate, long maxDate, String title, MonthFormat monthFormat) {
        return MonthYearPickerDialogFragment.getInstance(month, year, minDate, maxDate, title, null, monthFormat);
    }

    public static MonthYearPickerDialogFragment getInstance(int month, int year, long minDate, long maxDate, String title, Locale locale, MonthFormat monthFormat) {
        MonthYearPickerDialogFragment datePickerDialogFragment = new MonthYearPickerDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putInt(ARG_MONTH, month);
        bundle.putInt(ARG_YEAR, year);
        bundle.putLong(ARG_MIN_DATE, minDate);
        bundle.putLong(ARG_MAX_DATE, maxDate);
        bundle.putString(ARG_TITLE, title);
        bundle.putSerializable(ARG_MONTH_FORMAT, (Serializable)((Object)monthFormat));
        if (locale != null) {
            bundle.putSerializable(ARG_LOCALE, (Serializable)locale);
        }
        datePickerDialogFragment.setArguments(bundle);
        return datePickerDialogFragment;
    }

    public void setOnDateSetListener(MonthYearPickerDialog.OnDateSetListener onDateSetListener) {
        this.onDateSetListener = onDateSetListener;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle dataBundle = this.getArguments();
        if (dataBundle == null) {
            throw new AssertionError((Object)"Object cannot be null");
        }
        int year = dataBundle.getInt(ARG_YEAR);
        int month = dataBundle.getInt(ARG_MONTH);
        long minDate = dataBundle.getLong(ARG_MIN_DATE);
        long maxDate = dataBundle.getLong(ARG_MAX_DATE);
        String title = dataBundle.getString(ARG_TITLE);
        MonthFormat monthFormat = (MonthFormat)((Object)dataBundle.getSerializable(ARG_MONTH_FORMAT));
        Locale locale = Locale.getDefault();
        this.checkForValidMinDate(year, month, minDate);
        this.checkForValidMaxDate(year, month, maxDate);
        if (dataBundle.containsKey(ARG_LOCALE)) {
            locale = (Locale)dataBundle.getSerializable(ARG_LOCALE);
        }
        Locale.setDefault(locale);
        MonthYearPickerDialog simpleDatePickerDialog = new MonthYearPickerDialog((Context)this.getActivity(), year, month, monthFormat, this.onDateSetListener);
        if (minDate != -1L) {
            simpleDatePickerDialog.setMinDate(minDate);
        }
        if (maxDate != -1L) {
            simpleDatePickerDialog.setMaxDate(maxDate);
        }
        if (title != null && !title.isEmpty()) {
            simpleDatePickerDialog.createTitle(title);
        }
        return simpleDatePickerDialog;
    }

    private void checkForValidMinDate(int year, int month, long minDate) {
        Calendar c = Calendar.getInstance();
        c.add(1, year);
        c.add(2, month);
        if (c.getTimeInMillis() < minDate) {
            throw new IllegalArgumentException("The min date should be less than initial date set");
        }
    }

    private void checkForValidMaxDate(int year, int month, long maxDate) {
        Calendar c = Calendar.getInstance();
        c.add(1, year);
        c.add(2, month);
        if (c.getTimeInMillis() < maxDate) {
            throw new IllegalArgumentException("The max date should not be less than current date.");
        }
    }
}

