/*
 * Decompiled with CFR 0.152.
 */
package com.github.dewinjm.monthyearpicker;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import com.github.dewinjm.monthyearpicker.MonthFormat;
import com.github.dewinjm.monthyearpicker.PickerView;
import com.github.dewinjm.monthyearpicker.Presenter;
import com.github.dewinjm.monthyearpicker.R;
import java.text.DateFormatSymbols;
import java.util.Locale;

public class MonthYearPickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
Presenter.OnDateChangedListener {
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private Presenter presenter;
    private OnDateSetListener onDateSetListener;
    private String title;

    MonthYearPickerDialog(Context context, int year, int monthOfYear, OnDateSetListener listener) {
        this(context, 0, year, monthOfYear, MonthFormat.SHORT, listener);
    }

    MonthYearPickerDialog(Context context, int year, int monthOfYear, MonthFormat monthFormat, OnDateSetListener listener) {
        this(context, 0, year, monthOfYear, monthFormat, listener);
    }

    MonthYearPickerDialog(Context context, OnDateSetListener listener) {
        this(context, 0, 0, 0, MonthFormat.SHORT, listener);
    }

    private MonthYearPickerDialog(Context context, int theme, int year, int monthOfYear, MonthFormat monthFormat, OnDateSetListener listener) {
        this(context, theme, year, monthOfYear, true, monthFormat, listener);
    }

    @SuppressLint(value={"InflateParams"})
    private MonthYearPickerDialog(Context context, int theme, int year, int monthOfYear, boolean showSelectedDateTitle, MonthFormat monthFormat, OnDateSetListener listener) {
        super(context, theme);
        this.onDateSetListener = listener;
        Context themeContext = this.getContext();
        LayoutInflater inflater = LayoutInflater.from((Context)themeContext);
        View view = inflater.inflate(R.layout.month_year_picker, null);
        this.setView(view);
        if (showSelectedDateTitle) {
            this.createTitle(year, monthOfYear);
        }
        this.setButton(-1, themeContext.getString(17039370), this);
        this.setButton(-2, themeContext.getString(0x1040000), this);
        this.presenter = new Presenter(new PickerView(view), monthFormat);
        this.presenter.init(year, monthOfYear, this);
    }

    private void createTitle(int year, int monthOfYear) {
        Locale locale = Locale.getDefault();
        String month = new DateFormatSymbols().getMonths()[monthOfYear].toUpperCase(locale);
        this.createTitle(String.format(locale, "%s - %s", month, year));
    }

    void createTitle(String title) {
        this.title = title;
        this.setTitle(title);
    }

    String getTitle() {
        return this.title;
    }

    public void onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -1: {
                if (this.onDateSetListener == null) break;
                this.onDateSetListener.onDateSet(this.presenter.getYear(), this.presenter.getMonth());
                break;
            }
            case -2: {
                this.cancel();
            }
        }
    }

    @Override
    public void onDateChanged(int year, int monthOfYear) {
    }

    @NonNull
    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putInt(YEAR, this.presenter.getYear());
        state.putInt(MONTH, this.presenter.getMonth());
        return state;
    }

    public void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        int year = savedInstanceState.getInt(YEAR);
        int month = savedInstanceState.getInt(MONTH);
        this.presenter.init(year, month, this);
    }

    void setMinDate(long minDate) {
        this.presenter.setMinDate(minDate);
    }

    void setMaxDate(long maxDate) {
        this.presenter.setMaxDate(maxDate);
    }

    public static interface OnDateSetListener {
        public void onDateSet(int var1, int var2);
    }
}

