/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.util.support;

import cn.devezhao.persist4j.Entity;
import cn.devezhao.persist4j.Field;
import cn.devezhao.persist4j.dialect.Dialect;
import cn.devezhao.persist4j.dialect.FieldType;
import cn.devezhao.persist4j.dialect.MySQL5Dialect;
import cn.devezhao.persist4j.metadata.impl.EntityImpl;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class Table {
    private Entity entity;
    private Dialect dialect;
    private List<?> indexList;
    private List<String> autoValueIndex = new ArrayList<String>();
    private int indexNo = 0;
    static final String COLUMN_ = "%s %s";
    static final String PK_ = "primary key  ({0})";
    static final String FK_ = "index        ({0}),\n  foreign key  ({0})  references {1}({2})";

    public Table(Entity entity, Dialect dialect) {
        this(entity, dialect, null);
    }

    public Table(Entity entity, Dialect dialect, List<?> indexList) {
        this.entity = entity;
        this.dialect = dialect;
        this.indexList = indexList;
    }

    public String[] generateDDL(boolean dropExists, boolean createFk) {
        return this.generateDDL(dropExists, createFk, true);
    }

    public String[] generateDDL(boolean dropExists, boolean createFk, boolean allowZeroDate) {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        String table = this.entity.getPhysicalName();
        if (dropExists) {
            sql.append("drop table if exists ").append(this.dialect.quote(table)).append(";");
            sqls.add(sql.toString());
            sql = new StringBuilder();
            sql.append("create table /*!32312 if not exists*/ ").append(this.dialect.quote(table)).append(" (");
        } else {
            sql.append("create table if not exists ").append(this.dialect.quote(table)).append(" (");
        }
        String PK = "";
        ArrayList<Object[]> FKs = new ArrayList<Object[]>();
        Set<String> fields = ((EntityImpl)this.entity).getFieldSorted();
        for (String fs : fields) {
            Field field = this.entity.getField(fs);
            String column = field.getPhysicalName();
            if (field.getType() == FieldType.PRIMARY) {
                PK = column;
            } else if (field.getType() == FieldType.REFERENCE && createFk) {
                FKs.add(new Object[]{column, field.getReferenceEntities()[0]});
            }
            sql.append("\n  ");
            this.generateFieldDDL(field, sql, allowZeroDate);
            sql.append(",");
        }
        String pk = MessageFormat.format(PK_, this.dialect.quote(PK));
        sql.append("\n  ").append(pk);
        if (!FKs.isEmpty() && createFk) {
            sql.append(",\n");
            for (int i = 0; i < FKs.size(); ++i) {
                Object[] FK = (Object[])FKs.get(i);
                Entity e = (Entity)FK[1];
                sql.append("\n  ");
                sql.append(MessageFormat.format(FK_, StringUtils.rightPad((String)this.dialect.quote(FK[0].toString()), (int)20), this.dialect.quote(e.getPhysicalName()), this.dialect.quote(e.getPrimaryField().getPhysicalName())));
                if (i + 1 >= FKs.size()) continue;
                sql.append(',');
            }
        }
        for (String aix : this.autoValueIndex) {
            sql.append(",\n  ").append(aix);
        }
        for (String ix : this.generateIndexDDL()) {
            sql.append(",\n  ").append(ix);
        }
        sql.append("\n)");
        if (this.dialect.getClass() == MySQL5Dialect.class) {
            sql.append("Engine=InnoDB;");
        }
        sqls.add(sql.toString());
        return sqls.toArray(new String[0]);
    }

    public void generateFieldDDL(Field field, StringBuilder into) {
        this.generateFieldDDL(field, into, true);
    }

    public void generateFieldDDL(Field field, StringBuilder into, boolean allowZeroDate) {
        String defaultValue;
        String column = field.getPhysicalName();
        String type = this.dialect.getColumnType(field.getType().getMask());
        if (field.getType() == FieldType.DOUBLE || field.getType() == FieldType.DECIMAL) {
            type = String.format(type, field.getDecimalScale());
        }
        if (type.contains("%d") && field.getMaxLength() > 0) {
            type = field.getType() == FieldType.TEXT && field.getMaxLength() > 65535 ? "mediumtext" : String.format(type, field.getMaxLength());
        }
        String canNull = "";
        if (!field.isNullable()) {
            canNull = " not null";
            if (field.getType() == FieldType.TIMESTAMP) {
                canNull = canNull + " default " + (allowZeroDate ? "'0000-00-00 00:00:00'" : "current_timestamp");
            } else if (field.getType() == FieldType.DATE) {
                canNull = canNull + " default " + (allowZeroDate ? "'0000-00-00'" : "current_date");
            }
        } else if (field.getType() == FieldType.TIMESTAMP || field.getType() == FieldType.DATE) {
            canNull = canNull + " null default null";
        }
        String string = defaultValue = field.getDefaultValue() != null ? field.getDefaultValue().toString() : null;
        if (field.isAutoValue()) {
            canNull = canNull + " auto_increment";
        } else if (StringUtils.isNotBlank((String)defaultValue)) {
            if (canNull.contains("default")) {
                canNull = canNull.split("default")[0];
                canNull = canNull + " " + defaultValue.replaceAll("'", "") + "'";
            } else {
                canNull = canNull + " default '" + defaultValue.replaceAll("'", "") + "'";
            }
        }
        String ddl = String.format(COLUMN_, StringUtils.rightPad((String)this.dialect.quote(column), (int)20), type + canNull);
        if (StringUtils.isNotBlank((String)field.getDescription())) {
            ddl = this.dialect.getDialectName().startsWith("mysql") ? ddl + " comment '" + field.getDescription().replaceAll("'", "") + "'" : ddl + " /* " + field.getDescription() + " */";
        }
        into.append(ddl);
        if (field.isAutoValue()) {
            String aix = String.format("unique index AIX%d_%s (`%s`)", this.indexNo++, this.entity.getPhysicalName(), column);
            this.autoValueIndex.add(aix);
        }
    }

    protected String[] generateIndexDDL() {
        if (this.indexList == null || this.indexList.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> uix = new ArrayList<String>();
        for (Object o : this.indexList) {
            Element el = (Element)o;
            String type = el.attributeValue("type");
            if ("fulltext".equals(type) && !this.dialect.supportsFullText()) continue;
            String fieldList = el.attributeValue("field-list");
            String indexName = ("unique".equals(type) ? "UIX" : ("fulltext".equals(type) ? "FIX" : "IX")) + this.indexNo++ + '_' + this.entity.getPhysicalName();
            LinkedList<String> fpNames = new LinkedList<String>();
            for (String f : fieldList.split(",")) {
                fpNames.add(this.dialect.quote(this.entity.getField(f.trim()).getPhysicalName()));
            }
            String colNames = StringUtils.join(fpNames.iterator(), (String)", ");
            uix.add(("unique".equals(type) ? "unique " : ("fulltext".equals(type) ? "fulltext " : "")) + "index " + indexName + " (" + colNames + ")");
        }
        return uix.toArray(new String[0]);
    }
}

