/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.util.support;

import cn.devezhao.persist4j.Entity;
import cn.devezhao.persist4j.PersistException;
import cn.devezhao.persist4j.dialect.Dialect;
import cn.devezhao.persist4j.metadata.MetadataFactory;
import cn.devezhao.persist4j.metadata.impl.ConfigurationMetadataFactory;
import cn.devezhao.persist4j.util.SqlHelper;
import cn.devezhao.persist4j.util.support.Table;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.dom4j.Element;

public class SchemaExport {
    private final MetadataFactory metadataFactory;
    private final Dialect dialect;
    private final Connection connection;

    public SchemaExport(MetadataFactory metadataFactory, Dialect dialect, Connection connect) {
        this.metadataFactory = metadataFactory;
        this.dialect = dialect;
        this.connection = connect;
    }

    public void export(boolean dropExists, boolean createFK) {
        Entity[] entities = this.metadataFactory.getEntities();
        Element cfgRoot = ((ConfigurationMetadataFactory)this.metadataFactory).getConfigDocument().getRootElement();
        try {
            for (Entity entity : entities) {
                String[] sqls;
                Element entityElement = (Element)cfgRoot.selectSingleNode("//entity[@name='" + entity.getName() + "']");
                List ix = entityElement.selectNodes("index");
                for (String sql : sqls = new Table(entity, this.dialect, ix).generateDDL(dropExists, createFK)) {
                    try (Statement stmt = this.connection.createStatement();){
                        stmt.execute(sql);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new PersistException(null, e);
        }
        finally {
            SqlHelper.close(this.connection);
        }
    }
}

