/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.util;

import cn.devezhao.persist4j.exception.SqlExceptionConverter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.SQLWarningException;
import org.springframework.jdbc.datasource.DataSourceUtils;

public final class SqlHelper {
    private static final Log LOG = LogFactory.getLog(SqlHelper.class);

    public static void close(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            if (!rs.isClosed()) {
                rs.close();
            }
        }
        catch (Throwable ex) {
            SqlHelper.logSQLException(ex, "Unable to close JDBC ResultSet.");
        }
    }

    public static void close(Statement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            if (!stmt.isClosed()) {
                stmt.close();
            }
        }
        catch (Throwable ex) {
            SqlHelper.logSQLException(ex, "Unable to close JDBC Statement.");
        }
    }

    @Deprecated
    public static void close(Connection connect) {
        if (connect == null) {
            return;
        }
        try {
            if (!connect.isClosed()) {
                connect.close();
            }
        }
        catch (Throwable ex) {
            SqlHelper.logSQLException(ex, "Unable to close JDBC Connection.");
        }
    }

    public static void close(Connection connect, DataSource dataSource) {
        if (connect == null) {
            return;
        }
        Validate.notNull((Object)dataSource);
        try {
            DataSourceUtils.releaseConnection((Connection)connect, (DataSource)dataSource);
        }
        catch (Throwable ex) {
            SqlHelper.logSQLException(ex, "Unable to close JDBC Connection.");
        }
    }

    public static void clear(Statement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            if (stmt instanceof PreparedStatement) {
                ((PreparedStatement)stmt).clearParameters();
            }
            stmt.clearBatch();
            stmt.clearWarnings();
        }
        catch (Throwable ex) {
            SqlHelper.logSQLException(ex, "Unable to clear JDBC Statement.");
        }
    }

    public static void handleWarnings(SQLWarning warning, boolean ignoreWarnings) {
        if (warning == null) {
            return;
        }
        if (ignoreWarnings) {
            if (LOG.isDebugEnabled()) {
                for (SQLWarning warningToLog = warning; warningToLog != null; warningToLog = warningToLog.getNextWarning()) {
                    LOG.debug((Object)("SQLWarning ignored: SQL state '" + warningToLog.getSQLState() + "', error code '" + warningToLog.getErrorCode() + "', message [" + warningToLog.getMessage() + "]"));
                }
            }
        } else {
            throw new SQLWarningException("Warning not ignored", warning);
        }
    }

    public static boolean supportsBatchUpdates(Connection con) {
        try {
            DatabaseMetaData dbmd = con.getMetaData();
            if (dbmd.supportsBatchUpdates()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"JDBC driver supports batch updates");
                }
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"JDBC driver does not support batch updates");
            }
        }
        catch (SQLException ex) {
            LOG.debug((Object)("JDBC driver 'supportsBatchUpdates' method threw exception: " + ex));
        }
        catch (AbstractMethodError err) {
            LOG.debug((Object)("JDBC driver does not support JDBC 2.0 'supportsBatchUpdates' method: " + err));
        }
        return false;
    }

    static void logSQLException(Throwable ex, String message) {
        if (ex instanceof SQLException) {
            LOG.error((Object)SqlExceptionConverter.convert((SQLException)ex, message, null));
        } else if (ex.getCause() instanceof SQLException) {
            LOG.error((Object)SqlExceptionConverter.convert((SQLException)ex.getCause(), message, null));
        } else if (ex instanceof AbstractMethodError) {
            LOG.error((Object)("JDBC driver does not support. " + ex));
        } else {
            LOG.error((Object)("Unexception exception. " + ex));
        }
    }

    private SqlHelper() {
    }
}

