/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.record;

import cn.devezhao.commons.CalendarUtils;
import cn.devezhao.persist4j.Field;
import cn.devezhao.persist4j.Record;
import cn.devezhao.persist4j.dialect.FieldType;
import cn.devezhao.persist4j.dialect.Type;
import cn.devezhao.persist4j.dialect.editor.NTextEditor;
import cn.devezhao.persist4j.engine.ID;
import cn.devezhao.persist4j.record.FieldValueException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Time;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecordVisitor {
    private static final Log LOG = LogFactory.getLog(RecordVisitor.class);
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd";
    public static final String DATETIME_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss";
    private static final String[] DATEPARSE_MODES = new String[]{"yyyy", "yyyy-MM", "yyyy-MM-dd", "yyyy-MM-dd HH", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss"};

    public static void setValueByLiteral(String fieldName, String value, Record record) {
        RecordVisitor.setValueByLiteral(record.getEntity().getField(fieldName), value, record);
    }

    public static void setValueByLiteral(Field field, String value, Record record) {
        Object pVal;
        Type ft = field.getType();
        if (FieldType.PRIMARY.equals(ft) || FieldType.REFERENCE.equals(ft) || FieldType.ANY_REFERENCE.equals(ft)) {
            pVal = ID.valueOf(value);
        } else if (FieldType.REFERENCE_LIST.equals(ft)) {
            ArrayList<ID> ids = new ArrayList<ID>();
            for (String id : value.split(",")) {
                if (!ID.isId(id)) continue;
                ids.add(ID.valueOf(id));
            }
            pVal = ids.toArray(ID.EMPTY_ID_ARRAY);
        } else if (FieldType.INT.equals(ft) || FieldType.SMALL_INT.equals(ft)) {
            pVal = NumberUtils.toInt((String)RecordVisitor.clearNumber(value, Boolean.TRUE));
        } else if (FieldType.DOUBLE.equals(ft)) {
            pVal = NumberUtils.toDouble((String)RecordVisitor.clearNumber(value, Boolean.FALSE));
        } else if (FieldType.DECIMAL.equals(ft)) {
            pVal = new BigDecimal(RecordVisitor.clearNumber(value, Boolean.FALSE).toCharArray());
        } else if (FieldType.LONG.equals(ft)) {
            pVal = NumberUtils.toLong((String)RecordVisitor.clearNumber(value, Boolean.TRUE));
        } else if (FieldType.DATE.equals(ft) || FieldType.TIMESTAMP.equals(ft)) {
            pVal = RecordVisitor.tryParseDate(value);
        } else if (FieldType.TIME.equals(ft)) {
            pVal = RecordVisitor.tryParseTime(value);
        } else if (FieldType.BOOL.equals(ft)) {
            char ch = value.toUpperCase().charAt(0);
            pVal = ch == 'T';
        } else if (FieldType.NTEXT.equals(ft)) {
            pVal = new StringReader(value);
        } else {
            if (FieldType.BINARY.equals(ft)) {
                throw new UnsupportedOperationException("Unsupported Type: BINARY");
            }
            pVal = value;
        }
        record.setObjectValue(field.getName(), pVal);
    }

    public static String getLiteralByValue(Field field, Object value) {
        String literalValue;
        Type ft = field.getType();
        if (FieldType.PRIMARY.equals(ft) || FieldType.REFERENCE.equals(ft) || FieldType.ANY_REFERENCE.equals(ft)) {
            literalValue = ((ID)value).toLiteral();
        } else if (FieldType.REFERENCE_LIST.equals(ft)) {
            literalValue = StringUtils.join((Object[])((ID[])value), (String)",");
        } else if (FieldType.INT.equals(ft) || FieldType.SMALL_INT.equals(ft) || FieldType.DOUBLE.equals(ft) || FieldType.DECIMAL.equals(ft) || FieldType.LONG.equals(ft)) {
            literalValue = String.valueOf(value);
        } else if (FieldType.DATE.equals(ft)) {
            literalValue = RecordVisitor.getDefaultDateFormat().format((Date)value);
        } else if (FieldType.TIMESTAMP.equals(ft)) {
            literalValue = RecordVisitor.getDefaultDateTimeFormat().format((Date)value);
        } else if (FieldType.TIME.equals(ft)) {
            LocalTime lt = value instanceof Time ? ((Time)value).toLocalTime() : (LocalTime)value;
            literalValue = String.format("%02d:%02d:%02d", lt.getHour(), lt.getMinute(), lt.getSecond());
        } else if (FieldType.BOOL.equals(ft)) {
            literalValue = (Boolean)value != false ? "T" : "F";
        } else if (FieldType.NTEXT.equals(ft)) {
            literalValue = new NTextEditor().read2String(value).toString();
        } else {
            if (FieldType.BINARY.equals(ft)) {
                throw new UnsupportedOperationException("Unsupported Type: BINARY");
            }
            literalValue = value.toString();
        }
        return literalValue;
    }

    protected static String clearNumber(String num, boolean clearDecimal) {
        if (StringUtils.isBlank((String)num)) {
            return "0";
        }
        if (NumberUtils.isNumber((String)(num = num.replace(",", "").trim()))) {
            if (clearDecimal) {
                return num.split("\\.")[0];
            }
            return num;
        }
        LOG.warn((Object)("Bad number format : " + num));
        return "0";
    }

    public static DateFormat getDefaultDateFormat() {
        return new SimpleDateFormat(DATE_FORMAT_STRING);
    }

    public static DateFormat getDefaultDateTimeFormat() {
        return new SimpleDateFormat(DATETIME_FORMAT_STRING);
    }

    public static Date tryParseDate(String source) {
        if (StringUtils.isBlank((String)source)) {
            return null;
        }
        source = source.trim();
        int len = source.length();
        for (String mode : DATEPARSE_MODES) {
            if (mode.length() != len) continue;
            return CalendarUtils.parse((String)source, (DateFormat)CalendarUtils.getDateFormat((String)mode));
        }
        throw new FieldValueException("Invalid value of date: " + source);
    }

    public static LocalTime tryParseTime(String source) {
        if (NumberUtils.isNumber((String)source)) {
            long s = NumberUtils.toLong((String)source, (long)0L);
            return LocalTime.ofSecondOfDay(s);
        }
        String[] ss = source.split(":");
        try {
            int h = Integer.parseInt(ss[0]);
            int m = ss.length > 1 ? Integer.parseInt(ss[1]) : 0;
            int s = ss.length > 2 ? Integer.parseInt(ss[2]) : 0;
            return LocalTime.of(h, m, s);
        }
        catch (Exception ex) {
            throw new FieldValueException("Invalid value of time: " + source);
        }
    }
}

